<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for coveredTravelerType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Personenbezogene Daten einer versicherten Person (Reisender). | Contains identifying information as well as coverage requirements and journey information for each individual requesting coverage by the insurance plan.
 * @subpackage Structs
 */
class CoveredTravelerType extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: Eindeutiger Identifikator einer versicherten Person (Reisenden) | Unique covered person identifier
     * - use: required
     * @var int
     */
    public $ID;
    /**
     * The coveredPerson
     * Meta informations extracted from the WSDL
     * - documentation: Namensdaten der versicherten Person (Reisenden). | Name data of the covered person
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PersonType
     */
    public $coveredPerson;
    /**
     * The indCoverage
     * Meta informations extracted from the WSDL
     * - documentation: Individuelle Deckungssummen und Reisepreis der versicherten Person (Reisenden). | Container for individual coverage details.
     * - minOccurs: 0
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\IndCoverageType
     */
    public $indCoverage;
    /**
     * Constructor method for coveredTravelerType
     * @uses CoveredTravelerType::setID()
     * @uses CoveredTravelerType::setCoveredPerson()
     * @uses CoveredTravelerType::setIndCoverage()
     * @param int $iD
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PersonType $coveredPerson
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\IndCoverageType $indCoverage
     */
    public function __construct($iD = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PersonType $coveredPerson = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\IndCoverageType $indCoverage = null)
    {
        $this
            ->setID($iD)
            ->setCoveredPerson($coveredPerson)
            ->setIndCoverage($indCoverage);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CoveredTravelerType
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get coveredPerson value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PersonType|null
     */
    public function getCoveredPerson()
    {
        return $this->coveredPerson;
    }
    /**
     * Set coveredPerson value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PersonType $coveredPerson
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CoveredTravelerType
     */
    public function setCoveredPerson(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PersonType $coveredPerson = null)
    {
        $this->coveredPerson = $coveredPerson;
        return $this;
    }
    /**
     * Get indCoverage value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\IndCoverageType|null
     */
    public function getIndCoverage()
    {
        return $this->indCoverage;
    }
    /**
     * Set indCoverage value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\IndCoverageType $indCoverage
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CoveredTravelerType
     */
    public function setIndCoverage(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\IndCoverageType $indCoverage = null)
    {
        $this->indCoverage = $indCoverage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CoveredTravelerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
