<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ccValidType StructType
 * Meta informations extracted from the WSDL
 * - documentation: type for validity of credit card [Typ fuer Gueltigkeit von Kreditkarten]
 * @subpackage Structs
 */
class CcValidType extends AbstractStructBase
{
    /**
     * The mm
     * Meta informations extracted from the WSDL
     * - documentation: valid to month [Monat]
     * - maxInclusive: 12
     * - minInclusive: 1
     * @var int
     */
    public $mm;
    /**
     * The yyyy
     * Meta informations extracted from the WSDL
     * - documentation: valid to year [Year]
     * - maxInclusive: 9999
     * - minInclusive: 1000
     * @var int
     */
    public $yyyy;
    /**
     * Constructor method for ccValidType
     * @uses CcValidType::setMm()
     * @uses CcValidType::setYyyy()
     * @param int $mm
     * @param int $yyyy
     */
    public function __construct($mm = null, $yyyy = null)
    {
        $this
            ->setMm($mm)
            ->setYyyy($yyyy);
    }
    /**
     * Get mm value
     * @return int|null
     */
    public function getMm()
    {
        return $this->mm;
    }
    /**
     * Set mm value
     * @param int $mm
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CcValidType
     */
    public function setMm($mm = null)
    {
        // validation for constraint: maxInclusive
        if ($mm > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 12, "%s" given', $mm), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($mm < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $mm), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($mm) && !is_numeric($mm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($mm)), __LINE__);
        }
        $this->mm = $mm;
        return $this;
    }
    /**
     * Get yyyy value
     * @return int|null
     */
    public function getYyyy()
    {
        return $this->yyyy;
    }
    /**
     * Set yyyy value
     * @param int $yyyy
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CcValidType
     */
    public function setYyyy($yyyy = null)
    {
        // validation for constraint: maxInclusive
        if ($yyyy > 9999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9999, "%s" given', $yyyy), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($yyyy < 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1000, "%s" given', $yyyy), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($yyyy) && !is_numeric($yyyy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($yyyy)), __LINE__);
        }
        $this->yyyy = $yyyy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CcValidType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
