<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ccPaymentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: type for payment with credit card or with cc secureHandle ID [Typ fuer Kreditkartenzahlung oder mit cc secureHandle ID]
 * @subpackage Structs
 */
class CcPaymentType extends AbstractStructBase
{
    /**
     * The ccNr
     * Meta informations extracted from the WSDL
     * - documentation: Kreditkartennummer. | Credit card number embossed on the card. | type for creditcardnumber [Typ fuer Kreditkartennummer]
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $ccNr;
    /**
     * The ccHolder
     * Meta informations extracted from the WSDL
     * - documentation: credit card holder [Kreditkarteninhaber] | type for card holder [Typ fuer Karteninhaber]
     * - maxLength: 27
     * - minLength: 1
     * @var string
     */
    public $ccHolder;
    /**
     * The ccType
     * Meta informations extracted from the WSDL
     * - documentation: credit card insitute [Kreditkarteninsitut]
     * @var string
     */
    public $ccType;
    /**
     * The cvc2
     * Meta informations extracted from the WSDL
     * - documentation: additional check number [Pruefziffer] | type for cvc2 [Typ fuer CVC2]
     * - minOccurs: 0
     * - pattern: [0-9]{0,4}
     * @var string
     */
    public $cvc2;
    /**
     * The ccValid
     * Meta informations extracted from the WSDL
     * - documentation: valid to [Gueltig bis]
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CcValidType
     */
    public $ccValid;
    /**
     * The ccSecureHandleID
     * Meta informations extracted from the WSDL
     * - documentation: pay with cc secureHandle ID | type for ERV payment securehandle ID [Typ fuer ERV payment securehandle ID]
     * - maxLength: 128
     * - minLength: 0
     * @var string
     */
    public $ccSecureHandleID;
    /**
     * Constructor method for ccPaymentType
     * @uses CcPaymentType::setCcNr()
     * @uses CcPaymentType::setCcHolder()
     * @uses CcPaymentType::setCcType()
     * @uses CcPaymentType::setCvc2()
     * @uses CcPaymentType::setCcValid()
     * @uses CcPaymentType::setCcSecureHandleID()
     * @param string $ccNr
     * @param string $ccHolder
     * @param string $ccType
     * @param string $cvc2
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CcValidType $ccValid
     * @param string $ccSecureHandleID
     */
    public function __construct($ccNr = null, $ccHolder = null, $ccType = null, $cvc2 = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CcValidType $ccValid = null, $ccSecureHandleID = null)
    {
        $this
            ->setCcNr($ccNr)
            ->setCcHolder($ccHolder)
            ->setCcType($ccType)
            ->setCvc2($cvc2)
            ->setCcValid($ccValid)
            ->setCcSecureHandleID($ccSecureHandleID);
    }
    /**
     * Get ccNr value
     * @return string|null
     */
    public function getCcNr()
    {
        return $this->ccNr;
    }
    /**
     * Set ccNr value
     * @param string $ccNr
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CcPaymentType
     */
    public function setCcNr($ccNr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ccNr) && strlen($ccNr) > 20) || (is_array($ccNr) && count($ccNr) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($ccNr) ? strlen($ccNr) : count($ccNr)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($ccNr) && strlen($ccNr) < 1) || (is_array($ccNr) && count($ccNr) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ccNr) && !is_string($ccNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ccNr)), __LINE__);
        }
        $this->ccNr = $ccNr;
        return $this;
    }
    /**
     * Get ccHolder value
     * @return string|null
     */
    public function getCcHolder()
    {
        return $this->ccHolder;
    }
    /**
     * Set ccHolder value
     * @param string $ccHolder
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CcPaymentType
     */
    public function setCcHolder($ccHolder = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ccHolder) && strlen($ccHolder) > 27) || (is_array($ccHolder) && count($ccHolder) > 27)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 27 element(s) or a scalar of 27 character(s) at most, "%d" length given', is_scalar($ccHolder) ? strlen($ccHolder) : count($ccHolder)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($ccHolder) && strlen($ccHolder) < 1) || (is_array($ccHolder) && count($ccHolder) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ccHolder) && !is_string($ccHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ccHolder)), __LINE__);
        }
        $this->ccHolder = $ccHolder;
        return $this;
    }
    /**
     * Get ccType value
     * @return string|null
     */
    public function getCcType()
    {
        return $this->ccType;
    }
    /**
     * Set ccType value
     * @uses \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\CcType::valueIsValid()
     * @uses \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\CcType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ccType
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CcPaymentType
     */
    public function setCcType($ccType = null)
    {
        // validation for constraint: enumeration
        if (!\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\CcType::valueIsValid($ccType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ccType, implode(', ', \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\CcType::getValidValues())), __LINE__);
        }
        $this->ccType = $ccType;
        return $this;
    }
    /**
     * Get cvc2 value
     * @return string|null
     */
    public function getCvc2()
    {
        return $this->cvc2;
    }
    /**
     * Set cvc2 value
     * @param string $cvc2
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CcPaymentType
     */
    public function setCvc2($cvc2 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($cvc2) && !preg_match('/[0-9]{0,4}/', $cvc2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{0,4}", "%s" given', var_export($cvc2, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cvc2) && !is_string($cvc2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cvc2)), __LINE__);
        }
        $this->cvc2 = $cvc2;
        return $this;
    }
    /**
     * Get ccValid value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CcValidType|null
     */
    public function getCcValid()
    {
        return $this->ccValid;
    }
    /**
     * Set ccValid value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CcValidType $ccValid
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CcPaymentType
     */
    public function setCcValid(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CcValidType $ccValid = null)
    {
        $this->ccValid = $ccValid;
        return $this;
    }
    /**
     * Get ccSecureHandleID value
     * @return string|null
     */
    public function getCcSecureHandleID()
    {
        return $this->ccSecureHandleID;
    }
    /**
     * Set ccSecureHandleID value
     * @param string $ccSecureHandleID
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CcPaymentType
     */
    public function setCcSecureHandleID($ccSecureHandleID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ccSecureHandleID) && strlen($ccSecureHandleID) > 128) || (is_array($ccSecureHandleID) && count($ccSecureHandleID) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($ccSecureHandleID) ? strlen($ccSecureHandleID) : count($ccSecureHandleID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($ccSecureHandleID) && strlen($ccSecureHandleID) < 0) || (is_array($ccSecureHandleID) && count($ccSecureHandleID) < 0)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 0 element(s) or a scalar of 0 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ccSecureHandleID) && !is_string($ccSecureHandleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ccSecureHandleID)), __LINE__);
        }
        $this->ccSecureHandleID = $ccSecureHandleID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CcPaymentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
