<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for acceptedCard StructType
 * @subpackage Structs
 */
class AcceptedCard extends AbstractStructBase
{
    /**
     * The ccType
     * Meta informations extracted from the WSDL
     * - documentation: Bestimmt einen Kreditkartentyp, der zur Zahlung akzeptiert wird.
     * - use: required
     * @var string
     */
    public $ccType;
    /**
     * Constructor method for acceptedCard
     * @uses AcceptedCard::setCcType()
     * @param string $ccType
     */
    public function __construct($ccType = null)
    {
        $this
            ->setCcType($ccType);
    }
    /**
     * Get ccType value
     * @return string
     */
    public function getCcType()
    {
        return $this->ccType;
    }
    /**
     * Set ccType value
     * @uses \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\CcType::valueIsValid()
     * @uses \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\CcType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ccType
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AcceptedCard
     */
    public function setCcType($ccType = null)
    {
        // validation for constraint: enumeration
        if (!\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\CcType::valueIsValid($ccType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ccType, implode(', ', \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\CcType::getValidValues())), __LINE__);
        }
        $this->ccType = $ccType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AcceptedCard
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
