<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType;

/**
 * This class stands for ccType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: type for creditcard institutes [Typ fuer Kreditkarteninstitute]
 * @subpackage Enumerations
 */
class CcType
{
    /**
     * Constant for value 'e'
     * @return string 'e'
     */
    const VALUE_E = 'e';
    /**
     * Constant for value 'v'
     * @return string 'v'
     */
    const VALUE_V = 'v';
    /**
     * Constant for value 'a'
     * @return string 'a'
     */
    const VALUE_A = 'a';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_E
     * @uses self::VALUE_V
     * @uses self::VALUE_A
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_E,
            self::VALUE_V,
            self::VALUE_A,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
