<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType;

/**
 * This class stands for agreed EnumType
 * Meta informations extracted from the WSDL
 * - documentation: the autimatical prolongation must be agreed. | the AVBs must be agreed.
 * @subpackage Enumerations
 */
class Agreed
{
    /**
     * Constant for value 'true'
     * @return string 'true'
     */
    const VALUE_TRUE = 'true';
    /**
     * Constant for value 'TRUE'
     * @return string 'TRUE'
     */
    const VALUE_TRUE_1 = 'TRUE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TRUE
     * @uses self::VALUE_TRUE_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRUE,
            self::VALUE_TRUE_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
