<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType;

/**
 * This class stands for addressTravellerType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: type for address [Typ fuer Anrede]
 * @subpackage Enumerations
 */
class AddressTravellerType
{
    /**
     * Constant for value 'fr'
     * @return string 'fr'
     */
    const VALUE_FR = 'fr';
    /**
     * Constant for value 'hr'
     * @return string 'hr'
     */
    const VALUE_HR = 'hr';
    /**
     * Constant for value 'FR'
     * @return string 'FR'
     */
    const VALUE_FR_1 = 'FR';
    /**
     * Constant for value 'HR'
     * @return string 'HR'
     */
    const VALUE_HR_1 = 'HR';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FR
     * @uses self::VALUE_HR
     * @uses self::VALUE_FR_1
     * @uses self::VALUE_HR_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FR,
            self::VALUE_HR,
            self::VALUE_FR_1,
            self::VALUE_HR_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
