<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for totalPremium StructType
 * Meta informations extracted from the WSDL
 * - documentation: Gesamtpraemie | total premium
 * @subpackage Structs
 */
class TotalPremium extends AbstractStructBase
{
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - documentation: Es sind maximal 3-Dezimalstellen erlaubt. | Used for amounts, max 3 decimals
     * - fractionDigits: 3
     * - minInclusive: 0
     * @var float
     */
    public $amount;
    /**
     * The currencyCode
     * Meta informations extracted from the WSDL
     * - documentation: Währungskennzeichen nach ISO 4217 (3 Zeichen) | ISO 4217 currency code
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $currencyCode;
    /**
     * Constructor method for totalPremium
     * @uses TotalPremium::setAmount()
     * @uses TotalPremium::setCurrencyCode()
     * @param float $amount
     * @param string $currencyCode
     */
    public function __construct($amount = null, $currencyCode = null)
    {
        $this
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TotalPremium
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($amount) && strlen(substr($amount, strpos($amount, '.') + 1)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 fraction digits, "%d" given', strlen(substr($amount, strpos($amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $amount), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }
    /**
     * Set currencyCode value
     * @param string $currencyCode
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TotalPremium
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: pattern
        if (is_scalar($currencyCode) && !preg_match('/[a-zA-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-zA-Z]{3}", "%s" given', var_export($currencyCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->currencyCode = $currencyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TotalPremium
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
