<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for time StructType
 * Meta informations extracted from the WSDL
 * - documentation: travel time [Reisezeit]
 * @subpackage Structs
 */
class Time extends AbstractStructBase
{
    /**
     * The fromDate
     * Meta informations extracted from the WSDL
     * - documentation: begin date (ISO 8601) [Datum des Reisebeginns] CCYY-MM-DD
     * @var string
     */
    public $fromDate;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - documentation: end date (ISO 8601) [Datum des Reiseendes] CCYY-MM-DD
     * @var string
     */
    public $endDate;
    /**
     * The duration
     * Meta informations extracted from the WSDL
     * - documentation: duration in days [Reisedauer in Tagen] | type for travel Duration [Typ fuer Reisedauer]
     * - maxInclusive: 730
     * - minInclusive: 1
     * @var int
     */
    public $duration;
    /**
     * The bookingConfirmationDate
     * Meta informations extracted from the WSDL
     * - documentation: booking confirmation date (ISO 8601) [Datum der Buchungsbestätigung] CCYY-MM-DD
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bookingConfirmationDate;
    /**
     * Constructor method for time
     * @uses Time::setFromDate()
     * @uses Time::setEndDate()
     * @uses Time::setDuration()
     * @uses Time::setBookingConfirmationDate()
     * @param string $fromDate
     * @param string $endDate
     * @param int $duration
     * @param string $bookingConfirmationDate
     */
    public function __construct($fromDate = null, $endDate = null, $duration = null, $bookingConfirmationDate = null)
    {
        $this
            ->setFromDate($fromDate)
            ->setEndDate($endDate)
            ->setDuration($duration)
            ->setBookingConfirmationDate($bookingConfirmationDate);
    }
    /**
     * Get fromDate value
     * @return string|null
     */
    public function getFromDate()
    {
        return $this->fromDate;
    }
    /**
     * Set fromDate value
     * @param string $fromDate
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Time
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromDate)), __LINE__);
        }
        $this->fromDate = $fromDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Time
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get duration value
     * @return int|null
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @param int $duration
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Time
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: maxInclusive
        if ($duration > 730) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 730, "%s" given', $duration), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($duration < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $duration), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($duration) && !is_numeric($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($duration)), __LINE__);
        }
        $this->duration = $duration;
        return $this;
    }
    /**
     * Get bookingConfirmationDate value
     * @return string|null
     */
    public function getBookingConfirmationDate()
    {
        return $this->bookingConfirmationDate;
    }
    /**
     * Set bookingConfirmationDate value
     * @param string $bookingConfirmationDate
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Time
     */
    public function setBookingConfirmationDate($bookingConfirmationDate = null)
    {
        // validation for constraint: string
        if (!is_null($bookingConfirmationDate) && !is_string($bookingConfirmationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingConfirmationDate)), __LINE__);
        }
        $this->bookingConfirmationDate = $bookingConfirmationDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Time
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
