<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tariff StructType
 * @subpackage Structs
 */
class Tariff extends AbstractStructBase
{
    /**
     * The key
     * Meta informations extracted from the WSDL
     * - documentation: tariff key [Tarifschluessel] | Used for Character Strings, length 1 to 6.
     * - maxLength: 6
     * - minLength: 1
     * @var string
     */
    public $key;
    /**
     * The premium
     * Meta informations extracted from the WSDL
     * - documentation: tariff premium
     * - fractionDigits: 2
     * @var float
     */
    public $premium;
    /**
     * The renewalPremium
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: tariff renewal premium
     * - fractionDigits: 2
     * @var float
     */
    public $renewalPremium;
    /**
     * Constructor method for tariff
     * @uses Tariff::setKey()
     * @uses Tariff::setPremium()
     * @uses Tariff::setRenewalPremium()
     * @param string $key
     * @param float $premium
     * @param float $renewalPremium
     */
    public function __construct($key = null, $premium = null, $renewalPremium = null)
    {
        $this
            ->setKey($key)
            ->setPremium($premium)
            ->setRenewalPremium($renewalPremium);
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Tariff
     */
    public function setKey($key = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($key) && strlen($key) > 6) || (is_array($key) && count($key) > 6)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 6 element(s) or a scalar of 6 character(s) at most, "%d" length given', is_scalar($key) ? strlen($key) : count($key)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($key) && strlen($key) < 1) || (is_array($key) && count($key) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get premium value
     * @return float|null
     */
    public function getPremium()
    {
        return $this->premium;
    }
    /**
     * Set premium value
     * @param float $premium
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Tariff
     */
    public function setPremium($premium = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($premium) && strlen(substr($premium, strpos($premium, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($premium, strpos($premium, '.') + 1))), __LINE__);
        }
        $this->premium = $premium;
        return $this;
    }
    /**
     * Get renewalPremium value
     * @return float|null
     */
    public function getRenewalPremium()
    {
        return $this->renewalPremium;
    }
    /**
     * Set renewalPremium value
     * @param float $renewalPremium
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Tariff
     */
    public function setRenewalPremium($renewalPremium = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($renewalPremium) && strlen(substr($renewalPremium, strpos($renewalPremium, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($renewalPremium, strpos($renewalPremium, '.') + 1))), __LINE__);
        }
        $this->renewalPremium = $renewalPremium;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Tariff
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
