<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for serviceType StructType
 * Meta informations extracted from the WSDL
 * - documentation: type for service [Typ fuer Service]
 * @subpackage Structs
 */
class ServiceType extends AbstractStructBase
{
    /**
     * The serviceDesc
     * Meta informations extracted from the WSDL
     * - documentation: service description [Servicebeschreibung] | Used for Character Strings, length 1 to 100
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $serviceDesc;
    /**
     * The servicePremium
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ServicePremium
     */
    public $servicePremium;
    /**
     * The serviceRenewalPremium
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ServiceRenewalPremium
     */
    public $serviceRenewalPremium;
    /**
     * The serviceDescAndPremium
     * Meta informations extracted from the WSDL
     * - documentation: service description and service premium in one [Servicebeschreibung und Servicepreis zusammen] | Used for Character Strings, length 0 to 100
     * - maxLength: 100
     * - minLength: 0
     * @var string
     */
    public $serviceDescAndPremium;
    /**
     * The serviceDescAndRenewalPremium
     * Meta informations extracted from the WSDL
     * - documentation: service description and service renewal premium in one [Servicebeschreibung und Servicefolgepreis zusammen] | Used for Character Strings, length 0 to 100
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 0
     * @var string
     */
    public $serviceDescAndRenewalPremium;
    /**
     * The tariffs
     * Meta informations extracted from the WSDL
     * - documentation: tariff list [Tarife]
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TariffsType
     */
    public $tariffs;
    /**
     * Constructor method for serviceType
     * @uses ServiceType::setServiceDesc()
     * @uses ServiceType::setServicePremium()
     * @uses ServiceType::setServiceRenewalPremium()
     * @uses ServiceType::setServiceDescAndPremium()
     * @uses ServiceType::setServiceDescAndRenewalPremium()
     * @uses ServiceType::setTariffs()
     * @param string $serviceDesc
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ServicePremium $servicePremium
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ServiceRenewalPremium $serviceRenewalPremium
     * @param string $serviceDescAndPremium
     * @param string $serviceDescAndRenewalPremium
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TariffsType $tariffs
     */
    public function __construct($serviceDesc = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ServicePremium $servicePremium = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ServiceRenewalPremium $serviceRenewalPremium = null, $serviceDescAndPremium = null, $serviceDescAndRenewalPremium = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TariffsType $tariffs = null)
    {
        $this
            ->setServiceDesc($serviceDesc)
            ->setServicePremium($servicePremium)
            ->setServiceRenewalPremium($serviceRenewalPremium)
            ->setServiceDescAndPremium($serviceDescAndPremium)
            ->setServiceDescAndRenewalPremium($serviceDescAndRenewalPremium)
            ->setTariffs($tariffs);
    }
    /**
     * Get serviceDesc value
     * @return string|null
     */
    public function getServiceDesc()
    {
        return $this->serviceDesc;
    }
    /**
     * Set serviceDesc value
     * @param string $serviceDesc
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ServiceType
     */
    public function setServiceDesc($serviceDesc = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($serviceDesc) && strlen($serviceDesc) > 100) || (is_array($serviceDesc) && count($serviceDesc) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($serviceDesc) ? strlen($serviceDesc) : count($serviceDesc)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($serviceDesc) && strlen($serviceDesc) < 1) || (is_array($serviceDesc) && count($serviceDesc) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serviceDesc) && !is_string($serviceDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceDesc)), __LINE__);
        }
        $this->serviceDesc = $serviceDesc;
        return $this;
    }
    /**
     * Get servicePremium value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ServicePremium|null
     */
    public function getServicePremium()
    {
        return $this->servicePremium;
    }
    /**
     * Set servicePremium value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ServicePremium $servicePremium
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ServiceType
     */
    public function setServicePremium(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ServicePremium $servicePremium = null)
    {
        $this->servicePremium = $servicePremium;
        return $this;
    }
    /**
     * Get serviceRenewalPremium value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ServiceRenewalPremium|null
     */
    public function getServiceRenewalPremium()
    {
        return $this->serviceRenewalPremium;
    }
    /**
     * Set serviceRenewalPremium value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ServiceRenewalPremium $serviceRenewalPremium
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ServiceType
     */
    public function setServiceRenewalPremium(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ServiceRenewalPremium $serviceRenewalPremium = null)
    {
        $this->serviceRenewalPremium = $serviceRenewalPremium;
        return $this;
    }
    /**
     * Get serviceDescAndPremium value
     * @return string|null
     */
    public function getServiceDescAndPremium()
    {
        return $this->serviceDescAndPremium;
    }
    /**
     * Set serviceDescAndPremium value
     * @param string $serviceDescAndPremium
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ServiceType
     */
    public function setServiceDescAndPremium($serviceDescAndPremium = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($serviceDescAndPremium) && strlen($serviceDescAndPremium) > 100) || (is_array($serviceDescAndPremium) && count($serviceDescAndPremium) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($serviceDescAndPremium) ? strlen($serviceDescAndPremium) : count($serviceDescAndPremium)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($serviceDescAndPremium) && strlen($serviceDescAndPremium) < 0) || (is_array($serviceDescAndPremium) && count($serviceDescAndPremium) < 0)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 0 element(s) or a scalar of 0 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serviceDescAndPremium) && !is_string($serviceDescAndPremium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceDescAndPremium)), __LINE__);
        }
        $this->serviceDescAndPremium = $serviceDescAndPremium;
        return $this;
    }
    /**
     * Get serviceDescAndRenewalPremium value
     * @return string|null
     */
    public function getServiceDescAndRenewalPremium()
    {
        return $this->serviceDescAndRenewalPremium;
    }
    /**
     * Set serviceDescAndRenewalPremium value
     * @param string $serviceDescAndRenewalPremium
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ServiceType
     */
    public function setServiceDescAndRenewalPremium($serviceDescAndRenewalPremium = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($serviceDescAndRenewalPremium) && strlen($serviceDescAndRenewalPremium) > 100) || (is_array($serviceDescAndRenewalPremium) && count($serviceDescAndRenewalPremium) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($serviceDescAndRenewalPremium) ? strlen($serviceDescAndRenewalPremium) : count($serviceDescAndRenewalPremium)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($serviceDescAndRenewalPremium) && strlen($serviceDescAndRenewalPremium) < 0) || (is_array($serviceDescAndRenewalPremium) && count($serviceDescAndRenewalPremium) < 0)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 0 element(s) or a scalar of 0 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serviceDescAndRenewalPremium) && !is_string($serviceDescAndRenewalPremium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceDescAndRenewalPremium)), __LINE__);
        }
        $this->serviceDescAndRenewalPremium = $serviceDescAndRenewalPremium;
        return $this;
    }
    /**
     * Get tariffs value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TariffsType|null
     */
    public function getTariffs()
    {
        return $this->tariffs;
    }
    /**
     * Set tariffs value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TariffsType $tariffs
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ServiceType
     */
    public function setTariffs(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TariffsType $tariffs = null)
    {
        $this->tariffs = $tariffs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ServiceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
