<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for responsePreContractualInformation StructType
 * Meta informations extracted from the WSDL
 * - documentation: response with booking confirmation [Response mit Buchungsantwort]
 * @subpackage Structs
 */
class ResponsePreContractualInformation extends AbstractStructBase
{
    /**
     * The requestID
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: type for requestID [Typ fuer requestID]
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $requestID;
    /**
     * The responseID
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: type for responseID [Typ fuer responseID]
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $responseID;
    /**
     * The system
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRpType
     */
    public $system;
    /**
     * The preContractualInformationID
     * Meta informations extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 50.
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $preContractualInformationID;
    /**
     * The recordOfAdviceUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $recordOfAdviceUrl;
    /**
     * The preContractualInformation
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PreContractualInformationType
     */
    public $preContractualInformation;
    /**
     * The preContractualInformationText
     * Meta informations extracted from the WSDL
     * - maxLength: 500
     * - minLength: 1
     * @var string
     */
    public $preContractualInformationText;
    /**
     * The extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType
     */
    public $extensions;
    /**
     * The userError
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\UserErrorContainerType
     */
    public $userError;
    /**
     * The systemError
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemErrorContainerType
     */
    public $systemError;
    /**
     * Constructor method for responsePreContractualInformation
     * @uses ResponsePreContractualInformation::setRequestID()
     * @uses ResponsePreContractualInformation::setResponseID()
     * @uses ResponsePreContractualInformation::setSystem()
     * @uses ResponsePreContractualInformation::setPreContractualInformationID()
     * @uses ResponsePreContractualInformation::setRecordOfAdviceUrl()
     * @uses ResponsePreContractualInformation::setPreContractualInformation()
     * @uses ResponsePreContractualInformation::setPreContractualInformationText()
     * @uses ResponsePreContractualInformation::setExtensions()
     * @uses ResponsePreContractualInformation::setUserError()
     * @uses ResponsePreContractualInformation::setSystemError()
     * @param string $requestID
     * @param string $responseID
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRpType $system
     * @param string $preContractualInformationID
     * @param string $recordOfAdviceUrl
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PreContractualInformationType $preContractualInformation
     * @param string $preContractualInformationText
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\UserErrorContainerType $userError
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemErrorContainerType $systemError
     */
    public function __construct($requestID = null, $responseID = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRpType $system = null, $preContractualInformationID = null, $recordOfAdviceUrl = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PreContractualInformationType $preContractualInformation = null, $preContractualInformationText = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\UserErrorContainerType $userError = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemErrorContainerType $systemError = null)
    {
        $this
            ->setRequestID($requestID)
            ->setResponseID($responseID)
            ->setSystem($system)
            ->setPreContractualInformationID($preContractualInformationID)
            ->setRecordOfAdviceUrl($recordOfAdviceUrl)
            ->setPreContractualInformation($preContractualInformation)
            ->setPreContractualInformationText($preContractualInformationText)
            ->setExtensions($extensions)
            ->setUserError($userError)
            ->setSystemError($systemError);
    }
    /**
     * Get requestID value
     * @return string
     */
    public function getRequestID()
    {
        return $this->requestID;
    }
    /**
     * Set requestID value
     * @param string $requestID
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponsePreContractualInformation
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestID) && strlen($requestID) > 100) || (is_array($requestID) && count($requestID) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($requestID) ? strlen($requestID) : count($requestID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requestID) && strlen($requestID) < 1) || (is_array($requestID) && count($requestID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestID) && !is_string($requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestID)), __LINE__);
        }
        $this->requestID = $requestID;
        return $this;
    }
    /**
     * Get responseID value
     * @return string
     */
    public function getResponseID()
    {
        return $this->responseID;
    }
    /**
     * Set responseID value
     * @param string $responseID
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponsePreContractualInformation
     */
    public function setResponseID($responseID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($responseID) && strlen($responseID) > 100) || (is_array($responseID) && count($responseID) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($responseID) ? strlen($responseID) : count($responseID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($responseID) && strlen($responseID) < 1) || (is_array($responseID) && count($responseID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($responseID) && !is_string($responseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responseID)), __LINE__);
        }
        $this->responseID = $responseID;
        return $this;
    }
    /**
     * Get system value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRpType|null
     */
    public function getSystem()
    {
        return $this->system;
    }
    /**
     * Set system value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRpType $system
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponsePreContractualInformation
     */
    public function setSystem(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRpType $system = null)
    {
        $this->system = $system;
        return $this;
    }
    /**
     * Get preContractualInformationID value
     * @return string|null
     */
    public function getPreContractualInformationID()
    {
        return $this->preContractualInformationID;
    }
    /**
     * Set preContractualInformationID value
     * @param string $preContractualInformationID
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponsePreContractualInformation
     */
    public function setPreContractualInformationID($preContractualInformationID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($preContractualInformationID) && strlen($preContractualInformationID) > 50) || (is_array($preContractualInformationID) && count($preContractualInformationID) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($preContractualInformationID) ? strlen($preContractualInformationID) : count($preContractualInformationID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($preContractualInformationID) && strlen($preContractualInformationID) < 1) || (is_array($preContractualInformationID) && count($preContractualInformationID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($preContractualInformationID) && !is_string($preContractualInformationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preContractualInformationID)), __LINE__);
        }
        $this->preContractualInformationID = $preContractualInformationID;
        return $this;
    }
    /**
     * Get recordOfAdviceUrl value
     * @return string|null
     */
    public function getRecordOfAdviceUrl()
    {
        return $this->recordOfAdviceUrl;
    }
    /**
     * Set recordOfAdviceUrl value
     * @param string $recordOfAdviceUrl
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponsePreContractualInformation
     */
    public function setRecordOfAdviceUrl($recordOfAdviceUrl = null)
    {
        // validation for constraint: string
        if (!is_null($recordOfAdviceUrl) && !is_string($recordOfAdviceUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recordOfAdviceUrl)), __LINE__);
        }
        $this->recordOfAdviceUrl = $recordOfAdviceUrl;
        return $this;
    }
    /**
     * Get preContractualInformation value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PreContractualInformationType|null
     */
    public function getPreContractualInformation()
    {
        return $this->preContractualInformation;
    }
    /**
     * Set preContractualInformation value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PreContractualInformationType $preContractualInformation
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponsePreContractualInformation
     */
    public function setPreContractualInformation(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PreContractualInformationType $preContractualInformation = null)
    {
        $this->preContractualInformation = $preContractualInformation;
        return $this;
    }
    /**
     * Get preContractualInformationText value
     * @return string|null
     */
    public function getPreContractualInformationText()
    {
        return $this->preContractualInformationText;
    }
    /**
     * Set preContractualInformationText value
     * @param string $preContractualInformationText
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponsePreContractualInformation
     */
    public function setPreContractualInformationText($preContractualInformationText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($preContractualInformationText) && strlen($preContractualInformationText) > 500) || (is_array($preContractualInformationText) && count($preContractualInformationText) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($preContractualInformationText) ? strlen($preContractualInformationText) : count($preContractualInformationText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($preContractualInformationText) && strlen($preContractualInformationText) < 1) || (is_array($preContractualInformationText) && count($preContractualInformationText) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($preContractualInformationText) && !is_string($preContractualInformationText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preContractualInformationText)), __LINE__);
        }
        $this->preContractualInformationText = $preContractualInformationText;
        return $this;
    }
    /**
     * Get extensions value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType|null
     */
    public function getExtensions()
    {
        return $this->extensions;
    }
    /**
     * Set extensions value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponsePreContractualInformation
     */
    public function setExtensions(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions = null)
    {
        $this->extensions = $extensions;
        return $this;
    }
    /**
     * Get userError value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\UserErrorContainerType|null
     */
    public function getUserError()
    {
        return $this->userError;
    }
    /**
     * Set userError value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\UserErrorContainerType $userError
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponsePreContractualInformation
     */
    public function setUserError(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\UserErrorContainerType $userError = null)
    {
        $this->userError = $userError;
        return $this;
    }
    /**
     * Get systemError value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemErrorContainerType|null
     */
    public function getSystemError()
    {
        return $this->systemError;
    }
    /**
     * Set systemError value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemErrorContainerType $systemError
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponsePreContractualInformation
     */
    public function setSystemError(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemErrorContainerType $systemError = null)
    {
        $this->systemError = $systemError;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponsePreContractualInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
