<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for responseOffer StructType
 * Meta informations extracted from the WSDL
 * - documentation: response with ERV offers [Response mit ERV Angeboten]
 * @subpackage Structs
 */
class ResponseOffer extends AbstractStructBase
{
    /**
     * The requestID
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: type for requestID [Typ fuer requestID]
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $requestID;
    /**
     * The responseID
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: type for responseID [Typ fuer responseID]
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $responseID;
    /**
     * The system
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRpType
     */
    public $system;
    /**
     * The noCustomerCountryInfoText
     * Meta informations extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 250
     * - maxLength: 100
     * - minLength: 0
     * @var string
     */
    public $noCustomerCountryInfoText;
    /**
     * The offers
     * Meta informations extracted from the WSDL
     * - documentation: ERV offers [ERV Produkt Angebote]
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\OffersRpType
     */
    public $offers;
    /**
     * The insConditions
     * Meta informations extracted from the WSDL
     * - documentation: ERV insurance conditions (AVBs) [Versicherungsbediungen der ERV]
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\InsConditionsType
     */
    public $insConditions;
    /**
     * The prolongation
     * Meta informations extracted from the WSDL
     * - documentation: Agreement with automatical prolongation by anual insurances
     * - minOccurs: 0
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProlongationRpType
     */
    public $prolongation;
    /**
     * The extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType
     */
    public $extensions;
    /**
     * The systemError
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemErrorContainerType
     */
    public $systemError;
    /**
     * The userError
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\UserErrorContainerType
     */
    public $userError;
    /**
     * Constructor method for responseOffer
     * @uses ResponseOffer::setRequestID()
     * @uses ResponseOffer::setResponseID()
     * @uses ResponseOffer::setSystem()
     * @uses ResponseOffer::setNoCustomerCountryInfoText()
     * @uses ResponseOffer::setOffers()
     * @uses ResponseOffer::setInsConditions()
     * @uses ResponseOffer::setProlongation()
     * @uses ResponseOffer::setExtensions()
     * @uses ResponseOffer::setSystemError()
     * @uses ResponseOffer::setUserError()
     * @param string $requestID
     * @param string $responseID
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRpType $system
     * @param string $noCustomerCountryInfoText
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\OffersRpType $offers
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\InsConditionsType $insConditions
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProlongationRpType $prolongation
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemErrorContainerType $systemError
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\UserErrorContainerType $userError
     */
    public function __construct($requestID = null, $responseID = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRpType $system = null, $noCustomerCountryInfoText = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\OffersRpType $offers = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\InsConditionsType $insConditions = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProlongationRpType $prolongation = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemErrorContainerType $systemError = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\UserErrorContainerType $userError = null)
    {
        $this
            ->setRequestID($requestID)
            ->setResponseID($responseID)
            ->setSystem($system)
            ->setNoCustomerCountryInfoText($noCustomerCountryInfoText)
            ->setOffers($offers)
            ->setInsConditions($insConditions)
            ->setProlongation($prolongation)
            ->setExtensions($extensions)
            ->setSystemError($systemError)
            ->setUserError($userError);
    }
    /**
     * Get requestID value
     * @return string
     */
    public function getRequestID()
    {
        return $this->requestID;
    }
    /**
     * Set requestID value
     * @param string $requestID
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseOffer
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestID) && strlen($requestID) > 100) || (is_array($requestID) && count($requestID) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($requestID) ? strlen($requestID) : count($requestID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requestID) && strlen($requestID) < 1) || (is_array($requestID) && count($requestID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestID) && !is_string($requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestID)), __LINE__);
        }
        $this->requestID = $requestID;
        return $this;
    }
    /**
     * Get responseID value
     * @return string
     */
    public function getResponseID()
    {
        return $this->responseID;
    }
    /**
     * Set responseID value
     * @param string $responseID
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseOffer
     */
    public function setResponseID($responseID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($responseID) && strlen($responseID) > 100) || (is_array($responseID) && count($responseID) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($responseID) ? strlen($responseID) : count($responseID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($responseID) && strlen($responseID) < 1) || (is_array($responseID) && count($responseID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($responseID) && !is_string($responseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responseID)), __LINE__);
        }
        $this->responseID = $responseID;
        return $this;
    }
    /**
     * Get system value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRpType|null
     */
    public function getSystem()
    {
        return $this->system;
    }
    /**
     * Set system value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRpType $system
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseOffer
     */
    public function setSystem(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRpType $system = null)
    {
        $this->system = $system;
        return $this;
    }
    /**
     * Get noCustomerCountryInfoText value
     * @return string|null
     */
    public function getNoCustomerCountryInfoText()
    {
        return $this->noCustomerCountryInfoText;
    }
    /**
     * Set noCustomerCountryInfoText value
     * @param string $noCustomerCountryInfoText
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseOffer
     */
    public function setNoCustomerCountryInfoText($noCustomerCountryInfoText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($noCustomerCountryInfoText) && strlen($noCustomerCountryInfoText) > 100) || (is_array($noCustomerCountryInfoText) && count($noCustomerCountryInfoText) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($noCustomerCountryInfoText) ? strlen($noCustomerCountryInfoText) : count($noCustomerCountryInfoText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($noCustomerCountryInfoText) && strlen($noCustomerCountryInfoText) < 0) || (is_array($noCustomerCountryInfoText) && count($noCustomerCountryInfoText) < 0)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 0 element(s) or a scalar of 0 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($noCustomerCountryInfoText) && !is_string($noCustomerCountryInfoText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noCustomerCountryInfoText)), __LINE__);
        }
        $this->noCustomerCountryInfoText = $noCustomerCountryInfoText;
        return $this;
    }
    /**
     * Get offers value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\OffersRpType|null
     */
    public function getOffers()
    {
        return $this->offers;
    }
    /**
     * Set offers value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\OffersRpType $offers
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseOffer
     */
    public function setOffers(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\OffersRpType $offers = null)
    {
        $this->offers = $offers;
        return $this;
    }
    /**
     * Get insConditions value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\InsConditionsType|null
     */
    public function getInsConditions()
    {
        return $this->insConditions;
    }
    /**
     * Set insConditions value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\InsConditionsType $insConditions
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseOffer
     */
    public function setInsConditions(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\InsConditionsType $insConditions = null)
    {
        $this->insConditions = $insConditions;
        return $this;
    }
    /**
     * Get prolongation value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProlongationRpType|null
     */
    public function getProlongation()
    {
        return $this->prolongation;
    }
    /**
     * Set prolongation value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProlongationRpType $prolongation
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseOffer
     */
    public function setProlongation(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProlongationRpType $prolongation = null)
    {
        $this->prolongation = $prolongation;
        return $this;
    }
    /**
     * Get extensions value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType|null
     */
    public function getExtensions()
    {
        return $this->extensions;
    }
    /**
     * Set extensions value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseOffer
     */
    public function setExtensions(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions = null)
    {
        $this->extensions = $extensions;
        return $this;
    }
    /**
     * Get systemError value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemErrorContainerType|null
     */
    public function getSystemError()
    {
        return $this->systemError;
    }
    /**
     * Set systemError value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemErrorContainerType $systemError
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseOffer
     */
    public function setSystemError(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemErrorContainerType $systemError = null)
    {
        $this->systemError = $systemError;
        return $this;
    }
    /**
     * Get userError value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\UserErrorContainerType|null
     */
    public function getUserError()
    {
        return $this->userError;
    }
    /**
     * Set userError value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\UserErrorContainerType $userError
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseOffer
     */
    public function setUserError(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\UserErrorContainerType $userError = null)
    {
        $this->userError = $userError;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseOffer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
