<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for requestBooking StructType
 * Meta informations extracted from the WSDL
 * - documentation: request with demand of booking [Request mit Anforderung einer Buchung]
 * @subpackage Structs
 */
class RequestBooking extends AbstractStructBase
{
    /**
     * The requestID
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: type for requestID [Typ fuer requestID]
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $requestID;
    /**
     * The system
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType
     */
    public $system;
    /**
     * The agent
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType
     */
    public $agent;
    /**
     * The policyAsLink
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PolicyAsLink
     */
    public $policyAsLink;
    /**
     * The providerData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProviderDataType
     */
    public $providerData;
    /**
     * The productSpec
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProductSpecType
     */
    public $productSpec;
    /**
     * The travel
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType
     */
    public $travel;
    /**
     * The coveredTravelers
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CoveredTravelersType
     */
    public $coveredTravelers;
    /**
     * The offers
     * Meta informations extracted from the WSDL
     * - documentation: List of offers which the user has selected. Normally the user selected one.
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\OffersRqType
     */
    public $offers;
    /**
     * The preContractualInformationID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Used for Character Strings, length 1 to 50.
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $preContractualInformationID;
    /**
     * The customer
     * Meta informations extracted from the WSDL
     * - documentation: customer [Vertragsnehmer]
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType
     */
    public $customer;
    /**
     * The payment
     * Meta informations extracted from the WSDL
     * - documentation: payment [Zahlung]
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PaymentType
     */
    public $payment;
    /**
     * The insConditions
     * Meta informations extracted from the WSDL
     * - documentation: ERV insurance conditions (AVBs) [Versicherungsbediungen der ERV]
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\InsConditionsRqType
     */
    public $insConditions;
    /**
     * The prolongationAgreement
     * Meta informations extracted from the WSDL
     * - documentation: Agreement with automatical prolongation by anual insurances
     * - minOccurs: 0
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProlongationRqType
     */
    public $prolongationAgreement;
    /**
     * The extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType
     */
    public $extensions;
    /**
     * Constructor method for requestBooking
     * @uses RequestBooking::setRequestID()
     * @uses RequestBooking::setSystem()
     * @uses RequestBooking::setAgent()
     * @uses RequestBooking::setPolicyAsLink()
     * @uses RequestBooking::setProviderData()
     * @uses RequestBooking::setProductSpec()
     * @uses RequestBooking::setTravel()
     * @uses RequestBooking::setCoveredTravelers()
     * @uses RequestBooking::setOffers()
     * @uses RequestBooking::setPreContractualInformationID()
     * @uses RequestBooking::setCustomer()
     * @uses RequestBooking::setPayment()
     * @uses RequestBooking::setInsConditions()
     * @uses RequestBooking::setProlongationAgreement()
     * @uses RequestBooking::setExtensions()
     * @param string $requestID
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType $system
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType $agent
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PolicyAsLink $policyAsLink
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProviderDataType $providerData
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProductSpecType $productSpec
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType $travel
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CoveredTravelersType $coveredTravelers
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\OffersRqType $offers
     * @param string $preContractualInformationID
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType $customer
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PaymentType $payment
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\InsConditionsRqType $insConditions
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProlongationRqType $prolongationAgreement
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions
     */
    public function __construct($requestID = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType $system = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType $agent = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PolicyAsLink $policyAsLink = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProviderDataType $providerData = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProductSpecType $productSpec = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType $travel = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CoveredTravelersType $coveredTravelers = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\OffersRqType $offers = null, $preContractualInformationID = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType $customer = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PaymentType $payment = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\InsConditionsRqType $insConditions = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProlongationRqType $prolongationAgreement = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions = null)
    {
        $this
            ->setRequestID($requestID)
            ->setSystem($system)
            ->setAgent($agent)
            ->setPolicyAsLink($policyAsLink)
            ->setProviderData($providerData)
            ->setProductSpec($productSpec)
            ->setTravel($travel)
            ->setCoveredTravelers($coveredTravelers)
            ->setOffers($offers)
            ->setPreContractualInformationID($preContractualInformationID)
            ->setCustomer($customer)
            ->setPayment($payment)
            ->setInsConditions($insConditions)
            ->setProlongationAgreement($prolongationAgreement)
            ->setExtensions($extensions);
    }
    /**
     * Get requestID value
     * @return string
     */
    public function getRequestID()
    {
        return $this->requestID;
    }
    /**
     * Set requestID value
     * @param string $requestID
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestBooking
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestID) && strlen($requestID) > 100) || (is_array($requestID) && count($requestID) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($requestID) ? strlen($requestID) : count($requestID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requestID) && strlen($requestID) < 1) || (is_array($requestID) && count($requestID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestID) && !is_string($requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestID)), __LINE__);
        }
        $this->requestID = $requestID;
        return $this;
    }
    /**
     * Get system value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType|null
     */
    public function getSystem()
    {
        return $this->system;
    }
    /**
     * Set system value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType $system
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestBooking
     */
    public function setSystem(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\SystemRqType $system = null)
    {
        $this->system = $system;
        return $this;
    }
    /**
     * Get agent value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType|null
     */
    public function getAgent()
    {
        return $this->agent;
    }
    /**
     * Set agent value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType $agent
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestBooking
     */
    public function setAgent(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType $agent = null)
    {
        $this->agent = $agent;
        return $this;
    }
    /**
     * Get policyAsLink value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PolicyAsLink|null
     */
    public function getPolicyAsLink()
    {
        return $this->policyAsLink;
    }
    /**
     * Set policyAsLink value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PolicyAsLink $policyAsLink
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestBooking
     */
    public function setPolicyAsLink(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PolicyAsLink $policyAsLink = null)
    {
        $this->policyAsLink = $policyAsLink;
        return $this;
    }
    /**
     * Get providerData value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProviderDataType|null
     */
    public function getProviderData()
    {
        return $this->providerData;
    }
    /**
     * Set providerData value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProviderDataType $providerData
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestBooking
     */
    public function setProviderData(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProviderDataType $providerData = null)
    {
        $this->providerData = $providerData;
        return $this;
    }
    /**
     * Get productSpec value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProductSpecType|null
     */
    public function getProductSpec()
    {
        return $this->productSpec;
    }
    /**
     * Set productSpec value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProductSpecType $productSpec
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestBooking
     */
    public function setProductSpec(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProductSpecType $productSpec = null)
    {
        $this->productSpec = $productSpec;
        return $this;
    }
    /**
     * Get travel value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType|null
     */
    public function getTravel()
    {
        return $this->travel;
    }
    /**
     * Set travel value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType $travel
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestBooking
     */
    public function setTravel(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TravelType $travel = null)
    {
        $this->travel = $travel;
        return $this;
    }
    /**
     * Get coveredTravelers value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CoveredTravelersType|null
     */
    public function getCoveredTravelers()
    {
        return $this->coveredTravelers;
    }
    /**
     * Set coveredTravelers value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CoveredTravelersType $coveredTravelers
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestBooking
     */
    public function setCoveredTravelers(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CoveredTravelersType $coveredTravelers = null)
    {
        $this->coveredTravelers = $coveredTravelers;
        return $this;
    }
    /**
     * Get offers value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\OffersRqType|null
     */
    public function getOffers()
    {
        return $this->offers;
    }
    /**
     * Set offers value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\OffersRqType $offers
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestBooking
     */
    public function setOffers(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\OffersRqType $offers = null)
    {
        $this->offers = $offers;
        return $this;
    }
    /**
     * Get preContractualInformationID value
     * @return string|null
     */
    public function getPreContractualInformationID()
    {
        return $this->preContractualInformationID;
    }
    /**
     * Set preContractualInformationID value
     * @param string $preContractualInformationID
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestBooking
     */
    public function setPreContractualInformationID($preContractualInformationID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($preContractualInformationID) && strlen($preContractualInformationID) > 50) || (is_array($preContractualInformationID) && count($preContractualInformationID) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($preContractualInformationID) ? strlen($preContractualInformationID) : count($preContractualInformationID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($preContractualInformationID) && strlen($preContractualInformationID) < 1) || (is_array($preContractualInformationID) && count($preContractualInformationID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($preContractualInformationID) && !is_string($preContractualInformationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preContractualInformationID)), __LINE__);
        }
        $this->preContractualInformationID = $preContractualInformationID;
        return $this;
    }
    /**
     * Get customer value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType $customer
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestBooking
     */
    public function setCustomer(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\CustomerType $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get payment value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PaymentType|null
     */
    public function getPayment()
    {
        return $this->payment;
    }
    /**
     * Set payment value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PaymentType $payment
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestBooking
     */
    public function setPayment(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PaymentType $payment = null)
    {
        $this->payment = $payment;
        return $this;
    }
    /**
     * Get insConditions value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\InsConditionsRqType|null
     */
    public function getInsConditions()
    {
        return $this->insConditions;
    }
    /**
     * Set insConditions value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\InsConditionsRqType $insConditions
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestBooking
     */
    public function setInsConditions(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\InsConditionsRqType $insConditions = null)
    {
        $this->insConditions = $insConditions;
        return $this;
    }
    /**
     * Get prolongationAgreement value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProlongationRqType|null
     */
    public function getProlongationAgreement()
    {
        return $this->prolongationAgreement;
    }
    /**
     * Set prolongationAgreement value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProlongationRqType $prolongationAgreement
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestBooking
     */
    public function setProlongationAgreement(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProlongationRqType $prolongationAgreement = null)
    {
        $this->prolongationAgreement = $prolongationAgreement;
        return $this;
    }
    /**
     * Get extensions value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType|null
     */
    public function getExtensions()
    {
        return $this->extensions;
    }
    /**
     * Set extensions value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestBooking
     */
    public function setExtensions(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ExtensionsType $extensions = null)
    {
        $this->extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestBooking
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
