<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for providerDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: type for ERV provider data [ERV Provider Daten]
 * @subpackage Structs
 */
class ProviderDataType extends AbstractStructBase
{
    /**
     * The textField
     * Meta informations extracted from the WSDL
     * - documentation: textfield [Textfeld] | Used for Character Strings, length 0 to 60.
     * - maxLength: 60
     * - minLength: 0
     * @var string
     */
    public $textField;
    /**
     * Constructor method for providerDataType
     * @uses ProviderDataType::setTextField()
     * @param string $textField
     */
    public function __construct($textField = null)
    {
        $this
            ->setTextField($textField);
    }
    /**
     * Get textField value
     * @return string|null
     */
    public function getTextField()
    {
        return $this->textField;
    }
    /**
     * Set textField value
     * @param string $textField
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProviderDataType
     */
    public function setTextField($textField = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($textField) && strlen($textField) > 60) || (is_array($textField) && count($textField) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($textField) ? strlen($textField) : count($textField)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($textField) && strlen($textField) < 0) || (is_array($textField) && count($textField) < 0)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 0 element(s) or a scalar of 0 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($textField) && !is_string($textField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($textField)), __LINE__);
        }
        $this->textField = $textField;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProviderDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
