<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProlongationRpType StructType
 * Meta informations extracted from the WSDL
 * - documentation: type for Prolongation of anual insurances [Typ fuer Zustimmung zur automatischen Verlängerung von JV]
 * @subpackage Structs
 */
class ProlongationRpType extends AbstractStructBase
{
    /**
     * The agreement
     * Meta informations extracted from the WSDL
     * - documentation: der automatischen Verlängerung von JV muss zugestimmt werden [Text für Zustimmung der automatischen Verlängerung bei JV] | the AVBs must be agreed. this is the agreement text [Text für Zustimmung der AVBs]
     * - maxLength: 500
     * - minLength: 1
     * @var string
     */
    public $agreement;
    /**
     * The link
     * Meta informations extracted from the WSDL
     * - documentation: link for ERV AVBs
     * - minOccurs: 0
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\LinkType
     */
    public $link;
    /**
     * Constructor method for ProlongationRpType
     * @uses ProlongationRpType::setAgreement()
     * @uses ProlongationRpType::setLink()
     * @param string $agreement
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\LinkType $link
     */
    public function __construct($agreement = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\LinkType $link = null)
    {
        $this
            ->setAgreement($agreement)
            ->setLink($link);
    }
    /**
     * Get agreement value
     * @return string|null
     */
    public function getAgreement()
    {
        return $this->agreement;
    }
    /**
     * Set agreement value
     * @param string $agreement
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProlongationRpType
     */
    public function setAgreement($agreement = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($agreement) && strlen($agreement) > 500) || (is_array($agreement) && count($agreement) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($agreement) ? strlen($agreement) : count($agreement)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($agreement) && strlen($agreement) < 1) || (is_array($agreement) && count($agreement) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($agreement) && !is_string($agreement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agreement)), __LINE__);
        }
        $this->agreement = $agreement;
        return $this;
    }
    /**
     * Get link value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\LinkType|null
     */
    public function getLink()
    {
        return $this->link;
    }
    /**
     * Set link value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\LinkType $link
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProlongationRpType
     */
    public function setLink(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\LinkType $link = null)
    {
        $this->link = $link;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProlongationRpType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
