<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productSpecType StructType
 * Meta informations extracted from the WSDL
 * - documentation: type for ERV product specifics [ERV Produktspezifika]
 * @subpackage Structs
 */
class ProductSpecType extends AbstractStructBase
{
    /**
     * The productLine
     * Meta informations extracted from the WSDL
     * - documentation: productline [Produktlinie] | Used for Character Strings, length 1 to 30.
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $productLine;
    /**
     * The tourOperator
     * Meta informations extracted from the WSDL
     * - documentation: touroperator [Veranstalter] | Used for Character Strings, length 1 to 30.
     * - minOccurs: 0
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $tourOperator;
    /**
     * Constructor method for productSpecType
     * @uses ProductSpecType::setProductLine()
     * @uses ProductSpecType::setTourOperator()
     * @param string $productLine
     * @param string $tourOperator
     */
    public function __construct($productLine = null, $tourOperator = null)
    {
        $this
            ->setProductLine($productLine)
            ->setTourOperator($tourOperator);
    }
    /**
     * Get productLine value
     * @return string|null
     */
    public function getProductLine()
    {
        return $this->productLine;
    }
    /**
     * Set productLine value
     * @param string $productLine
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProductSpecType
     */
    public function setProductLine($productLine = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($productLine) && strlen($productLine) > 30) || (is_array($productLine) && count($productLine) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($productLine) ? strlen($productLine) : count($productLine)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($productLine) && strlen($productLine) < 1) || (is_array($productLine) && count($productLine) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($productLine) && !is_string($productLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productLine)), __LINE__);
        }
        $this->productLine = $productLine;
        return $this;
    }
    /**
     * Get tourOperator value
     * @return string|null
     */
    public function getTourOperator()
    {
        return $this->tourOperator;
    }
    /**
     * Set tourOperator value
     * @param string $tourOperator
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProductSpecType
     */
    public function setTourOperator($tourOperator = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($tourOperator) && strlen($tourOperator) > 30) || (is_array($tourOperator) && count($tourOperator) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($tourOperator) ? strlen($tourOperator) : count($tourOperator)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($tourOperator) && strlen($tourOperator) < 1) || (is_array($tourOperator) && count($tourOperator) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tourOperator) && !is_string($tourOperator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tourOperator)), __LINE__);
        }
        $this->tourOperator = $tourOperator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ProductSpecType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
