<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for preContractualInformationItemType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Container für Beschreibungsinformationen. | Container for description information
 * @subpackage Structs
 */
class PreContractualInformationItemType extends AbstractStructBase
{
    /**
     * The productName
     * Meta informations extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 100
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $productName;
    /**
     * The preContractualInformationUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DescriptionURLType[]
     */
    public $preContractualInformationUrl;
    /**
     * Constructor method for preContractualInformationItemType
     * @uses PreContractualInformationItemType::setProductName()
     * @uses PreContractualInformationItemType::setPreContractualInformationUrl()
     * @param string $productName
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DescriptionURLType[] $preContractualInformationUrl
     */
    public function __construct($productName = null, array $preContractualInformationUrl = array())
    {
        $this
            ->setProductName($productName)
            ->setPreContractualInformationUrl($preContractualInformationUrl);
    }
    /**
     * Get productName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->productName;
    }
    /**
     * Set productName value
     * @param string $productName
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PreContractualInformationItemType
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($productName) && strlen($productName) > 100) || (is_array($productName) && count($productName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($productName) ? strlen($productName) : count($productName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($productName) && strlen($productName) < 1) || (is_array($productName) && count($productName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productName)), __LINE__);
        }
        $this->productName = $productName;
        return $this;
    }
    /**
     * Get preContractualInformationUrl value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DescriptionURLType[]|null
     */
    public function getPreContractualInformationUrl()
    {
        return $this->preContractualInformationUrl;
    }
    /**
     * Set preContractualInformationUrl value
     * @throws \InvalidArgumentException
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DescriptionURLType[] $preContractualInformationUrl
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PreContractualInformationItemType
     */
    public function setPreContractualInformationUrl(array $preContractualInformationUrl = array())
    {
        foreach ($preContractualInformationUrl as $preContractualInformationItemTypePreContractualInformationUrlItem) {
            // validation for constraint: itemType
            if (!$preContractualInformationItemTypePreContractualInformationUrlItem instanceof \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DescriptionURLType) {
                throw new \InvalidArgumentException(sprintf('The preContractualInformationUrl property can only contain items of \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DescriptionURLType, "%s" given', is_object($preContractualInformationItemTypePreContractualInformationUrlItem) ? get_class($preContractualInformationItemTypePreContractualInformationUrlItem) : gettype($preContractualInformationItemTypePreContractualInformationUrlItem)), __LINE__);
            }
        }
        $this->preContractualInformationUrl = $preContractualInformationUrl;
        return $this;
    }
    /**
     * Add item to preContractualInformationUrl value
     * @throws \InvalidArgumentException
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DescriptionURLType $item
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PreContractualInformationItemType
     */
    public function addToPreContractualInformationUrl(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DescriptionURLType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DescriptionURLType) {
            throw new \InvalidArgumentException(sprintf('The preContractualInformationUrl property can only contain items of \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DescriptionURLType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->preContractualInformationUrl[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PreContractualInformationItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
