<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for policy StructType
 * @subpackage Structs
 */
class Policy extends AbstractStructBase
{
    /**
     * The vsnr
     * Meta informations extracted from the WSDL
     * - documentation: policy number [Versicherungsnummer] | policy number [Versicherungsnummer] | type for policyNumber [Typ fuer Versicherungsscheinnummer]
     * - pattern: [0-9]{9,10}
     * @var string
     */
    public $vsnr;
    /**
     * The totalPremium
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TotalPremium
     */
    public $totalPremium;
    /**
     * The totalRenewalPremium
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TotalRenewalPremium
     */
    public $totalRenewalPremium;
    /**
     * The policyPrintURL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 200
     * @var string
     */
    public $policyPrintURL;
    /**
     * The policyAttachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PolicyAttachments
     */
    public $policyAttachments;
    /**
     * Constructor method for policy
     * @uses Policy::setVsnr()
     * @uses Policy::setTotalPremium()
     * @uses Policy::setTotalRenewalPremium()
     * @uses Policy::setPolicyPrintURL()
     * @uses Policy::setPolicyAttachments()
     * @param string $vsnr
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TotalPremium $totalPremium
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TotalRenewalPremium $totalRenewalPremium
     * @param string $policyPrintURL
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PolicyAttachments $policyAttachments
     */
    public function __construct($vsnr = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TotalPremium $totalPremium = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TotalRenewalPremium $totalRenewalPremium = null, $policyPrintURL = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PolicyAttachments $policyAttachments = null)
    {
        $this
            ->setVsnr($vsnr)
            ->setTotalPremium($totalPremium)
            ->setTotalRenewalPremium($totalRenewalPremium)
            ->setPolicyPrintURL($policyPrintURL)
            ->setPolicyAttachments($policyAttachments);
    }
    /**
     * Get vsnr value
     * @return string|null
     */
    public function getVsnr()
    {
        return $this->vsnr;
    }
    /**
     * Set vsnr value
     * @param string $vsnr
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Policy
     */
    public function setVsnr($vsnr = null)
    {
        // validation for constraint: pattern
        if (is_scalar($vsnr) && !preg_match('/[0-9]{9,10}/', $vsnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{9,10}", "%s" given', var_export($vsnr, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vsnr) && !is_string($vsnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vsnr)), __LINE__);
        }
        $this->vsnr = $vsnr;
        return $this;
    }
    /**
     * Get totalPremium value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TotalPremium|null
     */
    public function getTotalPremium()
    {
        return $this->totalPremium;
    }
    /**
     * Set totalPremium value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TotalPremium $totalPremium
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Policy
     */
    public function setTotalPremium(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TotalPremium $totalPremium = null)
    {
        $this->totalPremium = $totalPremium;
        return $this;
    }
    /**
     * Get totalRenewalPremium value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TotalRenewalPremium|null
     */
    public function getTotalRenewalPremium()
    {
        return $this->totalRenewalPremium;
    }
    /**
     * Set totalRenewalPremium value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TotalRenewalPremium $totalRenewalPremium
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Policy
     */
    public function setTotalRenewalPremium(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\TotalRenewalPremium $totalRenewalPremium = null)
    {
        $this->totalRenewalPremium = $totalRenewalPremium;
        return $this;
    }
    /**
     * Get policyPrintURL value
     * @return string|null
     */
    public function getPolicyPrintURL()
    {
        return $this->policyPrintURL;
    }
    /**
     * Set policyPrintURL value
     * @param string $policyPrintURL
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Policy
     */
    public function setPolicyPrintURL($policyPrintURL = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($policyPrintURL) && strlen($policyPrintURL) > 200) || (is_array($policyPrintURL) && count($policyPrintURL) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($policyPrintURL) ? strlen($policyPrintURL) : count($policyPrintURL)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($policyPrintURL) && !is_string($policyPrintURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($policyPrintURL)), __LINE__);
        }
        $this->policyPrintURL = $policyPrintURL;
        return $this;
    }
    /**
     * Get policyAttachments value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PolicyAttachments|null
     */
    public function getPolicyAttachments()
    {
        return $this->policyAttachments;
    }
    /**
     * Set policyAttachments value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PolicyAttachments $policyAttachments
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Policy
     */
    public function setPolicyAttachments(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\PolicyAttachments $policyAttachments = null)
    {
        $this->policyAttachments = $policyAttachments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Policy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
