<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for offer StructType
 * @subpackage Structs
 */
class Offer extends AbstractStructBase
{
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - documentation: sequence for offer [Reihenfolge für Angebot/Produkt]
     * - maxExclusive: 100
     * - minInclusive: 1
     * @var int
     */
    public $sequence;
    /**
     * The offerID
     * Meta informations extracted from the WSDL
     * - documentation: Unique Reference number of offer [Eindeutige Offer-Referenz-Nummer] | Unique Reference number of offer [Eindeutige Offer-Referenz-Nummer] | Unique Reference number of offer [Eindeutige Offer-Referenz-Nummer]
     * - maxLength: 500
     * - minLength: 1
     * @var string
     */
    public $offerID;
    /**
     * The service
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Service
     */
    public $service;
    /**
     * The acceptedPayments
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AcceptedPayments
     */
    public $acceptedPayments;
    /**
     * The benefits
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Benefits
     */
    public $benefits;
    /**
     * Constructor method for offer
     * @uses Offer::setSequence()
     * @uses Offer::setOfferID()
     * @uses Offer::setService()
     * @uses Offer::setAcceptedPayments()
     * @uses Offer::setBenefits()
     * @param int $sequence
     * @param string $offerID
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Service $service
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AcceptedPayments $acceptedPayments
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Benefits $benefits
     */
    public function __construct($sequence = null, $offerID = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Service $service = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AcceptedPayments $acceptedPayments = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Benefits $benefits = null)
    {
        $this
            ->setSequence($sequence)
            ->setOfferID($offerID)
            ->setService($service)
            ->setAcceptedPayments($acceptedPayments)
            ->setBenefits($benefits);
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Offer
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: maxExclusive
        if ($sequence >= 100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 100, "%s" given', $sequence), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($sequence < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $sequence), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Get offerID value
     * @return string|null
     */
    public function getOfferID()
    {
        return $this->offerID;
    }
    /**
     * Set offerID value
     * @param string $offerID
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Offer
     */
    public function setOfferID($offerID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($offerID) && strlen($offerID) > 500) || (is_array($offerID) && count($offerID) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($offerID) ? strlen($offerID) : count($offerID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($offerID) && strlen($offerID) < 1) || (is_array($offerID) && count($offerID) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($offerID) && !is_string($offerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($offerID)), __LINE__);
        }
        $this->offerID = $offerID;
        return $this;
    }
    /**
     * Get service value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Service|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Service $service
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Offer
     */
    public function setService(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Service $service = null)
    {
        $this->service = $service;
        return $this;
    }
    /**
     * Get acceptedPayments value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AcceptedPayments|null
     */
    public function getAcceptedPayments()
    {
        return $this->acceptedPayments;
    }
    /**
     * Set acceptedPayments value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AcceptedPayments $acceptedPayments
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Offer
     */
    public function setAcceptedPayments(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AcceptedPayments $acceptedPayments = null)
    {
        $this->acceptedPayments = $acceptedPayments;
        return $this;
    }
    /**
     * Get benefits value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Benefits|null
     */
    public function getBenefits()
    {
        return $this->benefits;
    }
    /**
     * Set benefits value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Benefits $benefits
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Offer
     */
    public function setBenefits(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Benefits $benefits = null)
    {
        $this->benefits = $benefits;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\Offer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
