<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for localisationType StructType
 * Meta informations extracted from the WSDL
 * - documentation: type for locale informations [Typ fuer Laenderinformationen]
 * @subpackage Structs
 */
class LocalisationType extends AbstractStructBase
{
    /**
     * The countryCode
     * Meta informations extracted from the WSDL
     * - documentation: Country Code ISO 3166-1-Alpha-3 [Laenderkennzeichen] | Used for Alpha Strings, length 3
     * - pattern: [a-z]{3}|[A-Z]{3}
     * @var string
     */
    public $countryCode;
    /**
     * The languageCode
     * Meta informations extracted from the WSDL
     * - documentation: Language Code ISO 639-2-Alpha-2 [Sprachkennzeichen] | Language Code ISO 639-2-Alpha-2 [Sprachkennzeichen]
     * - pattern: [A-Z]{2}|[a-z]{2}
     * @var string
     */
    public $languageCode;
    /**
     * The currencyCode
     * Meta informations extracted from the WSDL
     * - documentation: Currency CODE ISO 4217-Alpha-3 [Währungskennzeichen] | Used for Alpha Strings, length 3
     * - pattern: [a-z]{3}|[A-Z]{3}
     * @var string
     */
    public $currencyCode;
    /**
     * Constructor method for localisationType
     * @uses LocalisationType::setCountryCode()
     * @uses LocalisationType::setLanguageCode()
     * @uses LocalisationType::setCurrencyCode()
     * @param string $countryCode
     * @param string $languageCode
     * @param string $currencyCode
     */
    public function __construct($countryCode = null, $languageCode = null, $currencyCode = null)
    {
        $this
            ->setCountryCode($countryCode)
            ->setLanguageCode($languageCode)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\LocalisationType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: pattern
        if (is_scalar($countryCode) && !preg_match('/[a-z]{3}|[A-Z]{3}/', $countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-z]{3}|[A-Z]{3}", "%s" given', var_export($countryCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get languageCode value
     * @return string|null
     */
    public function getLanguageCode()
    {
        return $this->languageCode;
    }
    /**
     * Set languageCode value
     * @param string $languageCode
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\LocalisationType
     */
    public function setLanguageCode($languageCode = null)
    {
        // validation for constraint: pattern
        if (is_scalar($languageCode) && !preg_match('/[A-Z]{2}|[a-z]{2}/', $languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z]{2}|[a-z]{2}", "%s" given', var_export($languageCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($languageCode) && !is_string($languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($languageCode)), __LINE__);
        }
        $this->languageCode = $languageCode;
        return $this;
    }
    /**
     * Get currencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }
    /**
     * Set currencyCode value
     * @param string $currencyCode
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\LocalisationType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: pattern
        if (is_scalar($currencyCode) && !preg_match('/[a-z]{3}|[A-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-z]{3}|[A-Z]{3}", "%s" given', var_export($currencyCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->currencyCode = $currencyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\LocalisationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
