<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for errorType StructType
 * Meta informations extracted from the WSDL
 * - documentation: type for an error [Typ fuer einen Fehleraufbau]
 * @subpackage Structs
 */
class ErrorType extends AbstractStructBase
{
    /**
     * The nr
     * Meta informations extracted from the WSDL
     * - minLength: 3
     * - documentation: type for error number [Typ fuer Fehlernummer]
     * - maxLength: 3
     * - pattern: [0-9]*
     * @var string
     */
    public $nr;
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - documentation: type for error message [Typ fuer Fehlermeldung]
     * - maxLength: 300
     * @var string
     */
    public $message;
    /**
     * Constructor method for errorType
     * @uses ErrorType::setNr()
     * @uses ErrorType::setMessage()
     * @param string $nr
     * @param string $message
     */
    public function __construct($nr = null, $message = null)
    {
        $this
            ->setNr($nr)
            ->setMessage($message);
    }
    /**
     * Get nr value
     * @return string|null
     */
    public function getNr()
    {
        return $this->nr;
    }
    /**
     * Set nr value
     * @param string $nr
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ErrorType
     */
    public function setNr($nr = null)
    {
        // validation for constraint: minLength
        if ((is_scalar($nr) && strlen($nr) < 3) || (is_array($nr) && count($nr) < 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at least', __LINE__);
        }
        // validation for constraint: maxLength
        if ((is_scalar($nr) && strlen($nr) > 3) || (is_array($nr) && count($nr) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($nr) ? strlen($nr) : count($nr)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($nr) && !preg_match('/[0-9]*/', $nr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]*", "%s" given', var_export($nr, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nr) && !is_string($nr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nr)), __LINE__);
        }
        $this->nr = $nr;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ErrorType
     */
    public function setMessage($message = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($message) && strlen($message) > 300) || (is_array($message) && count($message) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($message) ? strlen($message) : count($message)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ErrorType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
