<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for differingAccountHolderType StructType
 * @subpackage Structs
 */
class DifferingAccountHolderType extends AbstractStructBase
{
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The prename
     * Meta informations extracted from the WSDL
     * - documentation: Used for Character Strings, length 0 to 30.
     * - maxLength: 30
     * - minLength: 0
     * @var string
     */
    public $prename;
    /**
     * The surname
     * Meta informations extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 30.
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $surname;
    /**
     * The streetAndNr
     * Meta informations extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 30.
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $streetAndNr;
    /**
     * The zipCode
     * Meta informations extracted from the WSDL
     * - documentation: zip code [PLZ] | Used for Character Strings, length 1 to 7.
     * - maxLength: 7
     * - minLength: 1
     * @var string
     */
    public $zipCode;
    /**
     * The city
     * Meta informations extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 30.
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $city;
    /**
     * The countryCode
     * Meta informations extracted from the WSDL
     * - documentation: Used for Alpha Strings, length 3
     * - pattern: [a-z]{3}|[A-Z]{3}
     * @var string
     */
    public $countryCode;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 100
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $email;
    /**
     * Constructor method for differingAccountHolderType
     * @uses DifferingAccountHolderType::setAddress()
     * @uses DifferingAccountHolderType::setPrename()
     * @uses DifferingAccountHolderType::setSurname()
     * @uses DifferingAccountHolderType::setStreetAndNr()
     * @uses DifferingAccountHolderType::setZipCode()
     * @uses DifferingAccountHolderType::setCity()
     * @uses DifferingAccountHolderType::setCountryCode()
     * @uses DifferingAccountHolderType::setEmail()
     * @param string $address
     * @param string $prename
     * @param string $surname
     * @param string $streetAndNr
     * @param string $zipCode
     * @param string $city
     * @param string $countryCode
     * @param string $email
     */
    public function __construct($address = null, $prename = null, $surname = null, $streetAndNr = null, $zipCode = null, $city = null, $countryCode = null, $email = null)
    {
        $this
            ->setAddress($address)
            ->setPrename($prename)
            ->setSurname($surname)
            ->setStreetAndNr($streetAndNr)
            ->setZipCode($zipCode)
            ->setCity($city)
            ->setCountryCode($countryCode)
            ->setEmail($email);
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @uses \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\AddressDifferingAccountHolderType::valueIsValid()
     * @uses \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\AddressDifferingAccountHolderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $address
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DifferingAccountHolderType
     */
    public function setAddress($address = null)
    {
        // validation for constraint: enumeration
        if (!\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\AddressDifferingAccountHolderType::valueIsValid($address)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $address, implode(', ', \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType\AddressDifferingAccountHolderType::getValidValues())), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get prename value
     * @return string|null
     */
    public function getPrename()
    {
        return $this->prename;
    }
    /**
     * Set prename value
     * @param string $prename
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DifferingAccountHolderType
     */
    public function setPrename($prename = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($prename) && strlen($prename) > 30) || (is_array($prename) && count($prename) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($prename) ? strlen($prename) : count($prename)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($prename) && strlen($prename) < 0) || (is_array($prename) && count($prename) < 0)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 0 element(s) or a scalar of 0 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($prename) && !is_string($prename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prename)), __LINE__);
        }
        $this->prename = $prename;
        return $this;
    }
    /**
     * Get surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->surname;
    }
    /**
     * Set surname value
     * @param string $surname
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DifferingAccountHolderType
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($surname) && strlen($surname) > 30) || (is_array($surname) && count($surname) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($surname) ? strlen($surname) : count($surname)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($surname) && strlen($surname) < 1) || (is_array($surname) && count($surname) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surname)), __LINE__);
        }
        $this->surname = $surname;
        return $this;
    }
    /**
     * Get streetAndNr value
     * @return string|null
     */
    public function getStreetAndNr()
    {
        return $this->streetAndNr;
    }
    /**
     * Set streetAndNr value
     * @param string $streetAndNr
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DifferingAccountHolderType
     */
    public function setStreetAndNr($streetAndNr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($streetAndNr) && strlen($streetAndNr) > 30) || (is_array($streetAndNr) && count($streetAndNr) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($streetAndNr) ? strlen($streetAndNr) : count($streetAndNr)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($streetAndNr) && strlen($streetAndNr) < 1) || (is_array($streetAndNr) && count($streetAndNr) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($streetAndNr) && !is_string($streetAndNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetAndNr)), __LINE__);
        }
        $this->streetAndNr = $streetAndNr;
        return $this;
    }
    /**
     * Get zipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->zipCode;
    }
    /**
     * Set zipCode value
     * @param string $zipCode
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DifferingAccountHolderType
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($zipCode) && strlen($zipCode) > 7) || (is_array($zipCode) && count($zipCode) > 7)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 7 element(s) or a scalar of 7 character(s) at most, "%d" length given', is_scalar($zipCode) ? strlen($zipCode) : count($zipCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($zipCode) && strlen($zipCode) < 1) || (is_array($zipCode) && count($zipCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        $this->zipCode = $zipCode;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DifferingAccountHolderType
     */
    public function setCity($city = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($city) && strlen($city) > 30) || (is_array($city) && count($city) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($city) ? strlen($city) : count($city)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($city) && strlen($city) < 1) || (is_array($city) && count($city) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DifferingAccountHolderType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: pattern
        if (is_scalar($countryCode) && !preg_match('/[a-z]{3}|[A-Z]{3}/', $countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-z]{3}|[A-Z]{3}", "%s" given', var_export($countryCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DifferingAccountHolderType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($email) && strlen($email) > 100) || (is_array($email) && count($email) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($email) ? strlen($email) : count($email)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($email) && strlen($email) < 1) || (is_array($email) && count($email) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DifferingAccountHolderType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
