<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DescriptionURLType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Container für Beschreibungsinformationen. | Container for description information
 * @subpackage Structs
 */
class DescriptionURLType extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: Used for Character Strings, length 1 to 16.
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $type;
    /**
     * The label
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: Used for Character Strings, length 1 to 100
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $label;
    /**
     * The defaultInd
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $defaultInd;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * Constructor method for DescriptionURLType
     * @uses DescriptionURLType::setType()
     * @uses DescriptionURLType::setLabel()
     * @uses DescriptionURLType::setDefaultInd()
     * @uses DescriptionURLType::set_()
     * @param string $type
     * @param string $label
     * @param bool $defaultInd
     * @param string $_
     */
    public function __construct($type = null, $label = null, $defaultInd = null, $_ = null)
    {
        $this
            ->setType($type)
            ->setLabel($label)
            ->setDefaultInd($defaultInd)
            ->set_($_);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DescriptionURLType
     */
    public function setType($type = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($type) && strlen($type) > 16) || (is_array($type) && count($type) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($type) ? strlen($type) : count($type)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($type) && strlen($type) < 1) || (is_array($type) && count($type) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get label value
     * @return string
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DescriptionURLType
     */
    public function setLabel($label = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($label) && strlen($label) > 100) || (is_array($label) && count($label) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($label) ? strlen($label) : count($label)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($label) && strlen($label) < 1) || (is_array($label) && count($label) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get defaultInd value
     * @return bool
     */
    public function getDefaultInd()
    {
        return $this->defaultInd;
    }
    /**
     * Set defaultInd value
     * @param bool $defaultInd
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DescriptionURLType
     */
    public function setDefaultInd($defaultInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultInd) && !is_bool($defaultInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($defaultInd)), __LINE__);
        }
        $this->defaultInd = $defaultInd;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DescriptionURLType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DescriptionURLType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
