<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bankPaymentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: type for payment with credit card or with cc secureHandle ID [Typ fuer Kreditkartenzahlung oder mit cc secureHandle ID]
 * @subpackage Structs
 */
class BankPaymentType extends AbstractStructBase
{
    /**
     * The bankNumber
     * Meta informations extracted from the WSDL
     * - documentation: bank number [Bankleitzahl] | type for bank Number [Typ fuer Bankleitzahl]
     * - minOccurs: 0
     * @var string
     */
    public $bankNumber;
    /**
     * The accountNumber
     * Meta informations extracted from the WSDL
     * - documentation: account number [Kontonummer] | type for account number [Typ fuer Kontonummer ]
     * @var string
     */
    public $accountNumber;
    /**
     * The differingAccountHolder
     * Meta informations extracted from the WSDL
     * - documentation: differing account holder [vom VN abweichender Kontoinhaber]
     * - minOccurs: 0
     * @var \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DifferingAccountHolderType
     */
    public $differingAccountHolder;
    /**
     * The bankSecureHandleID
     * Meta informations extracted from the WSDL
     * - documentation: pay with cc secureHandle ID | type for ERV payment securehandle ID [Typ fuer ERV payment securehandle ID]
     * - maxLength: 128
     * - minLength: 0
     * @var string
     */
    public $bankSecureHandleID;
    /**
     * Constructor method for bankPaymentType
     * @uses BankPaymentType::setBankNumber()
     * @uses BankPaymentType::setAccountNumber()
     * @uses BankPaymentType::setDifferingAccountHolder()
     * @uses BankPaymentType::setBankSecureHandleID()
     * @param string $bankNumber
     * @param string $accountNumber
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DifferingAccountHolderType $differingAccountHolder
     * @param string $bankSecureHandleID
     */
    public function __construct($bankNumber = null, $accountNumber = null, \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DifferingAccountHolderType $differingAccountHolder = null, $bankSecureHandleID = null)
    {
        $this
            ->setBankNumber($bankNumber)
            ->setAccountNumber($accountNumber)
            ->setDifferingAccountHolder($differingAccountHolder)
            ->setBankSecureHandleID($bankSecureHandleID);
    }
    /**
     * Get bankNumber value
     * @return string|null
     */
    public function getBankNumber()
    {
        return $this->bankNumber;
    }
    /**
     * Set bankNumber value
     * @param string $bankNumber
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\BankPaymentType
     */
    public function setBankNumber($bankNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankNumber) && !is_string($bankNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankNumber)), __LINE__);
        }
        $this->bankNumber = $bankNumber;
        return $this;
    }
    /**
     * Get accountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param string $accountNumber
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\BankPaymentType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get differingAccountHolder value
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DifferingAccountHolderType|null
     */
    public function getDifferingAccountHolder()
    {
        return $this->differingAccountHolder;
    }
    /**
     * Set differingAccountHolder value
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DifferingAccountHolderType $differingAccountHolder
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\BankPaymentType
     */
    public function setDifferingAccountHolder(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\DifferingAccountHolderType $differingAccountHolder = null)
    {
        $this->differingAccountHolder = $differingAccountHolder;
        return $this;
    }
    /**
     * Get bankSecureHandleID value
     * @return string|null
     */
    public function getBankSecureHandleID()
    {
        return $this->bankSecureHandleID;
    }
    /**
     * Set bankSecureHandleID value
     * @param string $bankSecureHandleID
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\BankPaymentType
     */
    public function setBankSecureHandleID($bankSecureHandleID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bankSecureHandleID) && strlen($bankSecureHandleID) > 128) || (is_array($bankSecureHandleID) && count($bankSecureHandleID) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($bankSecureHandleID) ? strlen($bankSecureHandleID) : count($bankSecureHandleID)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bankSecureHandleID) && strlen($bankSecureHandleID) < 0) || (is_array($bankSecureHandleID) && count($bankSecureHandleID) < 0)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 0 element(s) or a scalar of 0 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankSecureHandleID) && !is_string($bankSecureHandleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankSecureHandleID)), __LINE__);
        }
        $this->bankSecureHandleID = $bankSecureHandleID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\BankPaymentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
