<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for agentWarningType StructType
 * Meta informations extracted from the WSDL
 * - documentation: type for ERV agencynumber [Typ fuer ERV AgenturNummer]
 * @subpackage Structs
 */
class AgentWarningType extends AbstractStructBase
{
    /**
     * The warning
     * Meta informations extracted from the WSDL
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $warning;
    /**
     * Constructor method for agentWarningType
     * @uses AgentWarningType::setWarning()
     * @param string $warning
     */
    public function __construct($warning = null)
    {
        $this
            ->setWarning($warning);
    }
    /**
     * Get warning value
     * @return string|null
     */
    public function getWarning()
    {
        return $this->warning;
    }
    /**
     * Set warning value
     * @param string $warning
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentWarningType
     */
    public function setWarning($warning = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($warning) && strlen($warning) > 300) || (is_array($warning) && count($warning) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($warning) ? strlen($warning) : count($warning)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($warning) && strlen($warning) < 1) || (is_array($warning) && count($warning) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($warning) && !is_string($warning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warning)), __LINE__);
        }
        $this->warning = $warning;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentWarningType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
