<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for agentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: type for ERV agencynumber [Typ fuer ERV AgenturNummer]
 * @subpackage Structs
 */
class AgentType extends AbstractStructBase
{
    /**
     * The agency
     * Meta informations extracted from the WSDL
     * - documentation: Agency number of the requesting POS | Used for Character Strings, length 1 to 64.
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $agency;
    /**
     * The travelAgent
     * Meta informations extracted from the WSDL
     * - documentation: travel agent [Expedient] | Used for Character Strings, length 1 to 30.
     * - minOccurs: 0
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $travelAgent;
    /**
     * The providerAss
     * Meta informations extracted from the WSDL
     * - documentation: identifier for provider [Kennzeichen fuer Provider] | type for ERV agency structure key[Typ fuer AgenturStrukturSchluessel]
     * - minOccurs: 0
     * - pattern: [0-9]{1,5}
     * @var string
     */
    public $providerAss;
    /**
     * Constructor method for agentType
     * @uses AgentType::setAgency()
     * @uses AgentType::setTravelAgent()
     * @uses AgentType::setProviderAss()
     * @param string $agency
     * @param string $travelAgent
     * @param string $providerAss
     */
    public function __construct($agency = null, $travelAgent = null, $providerAss = null)
    {
        $this
            ->setAgency($agency)
            ->setTravelAgent($travelAgent)
            ->setProviderAss($providerAss);
    }
    /**
     * Get agency value
     * @return string|null
     */
    public function getAgency()
    {
        return $this->agency;
    }
    /**
     * Set agency value
     * @param string $agency
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType
     */
    public function setAgency($agency = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($agency) && strlen($agency) > 64) || (is_array($agency) && count($agency) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($agency) ? strlen($agency) : count($agency)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($agency) && strlen($agency) < 1) || (is_array($agency) && count($agency) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($agency) && !is_string($agency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agency)), __LINE__);
        }
        $this->agency = $agency;
        return $this;
    }
    /**
     * Get travelAgent value
     * @return string|null
     */
    public function getTravelAgent()
    {
        return $this->travelAgent;
    }
    /**
     * Set travelAgent value
     * @param string $travelAgent
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType
     */
    public function setTravelAgent($travelAgent = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($travelAgent) && strlen($travelAgent) > 30) || (is_array($travelAgent) && count($travelAgent) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($travelAgent) ? strlen($travelAgent) : count($travelAgent)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($travelAgent) && strlen($travelAgent) < 1) || (is_array($travelAgent) && count($travelAgent) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($travelAgent) && !is_string($travelAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelAgent)), __LINE__);
        }
        $this->travelAgent = $travelAgent;
        return $this;
    }
    /**
     * Get providerAss value
     * @return string|null
     */
    public function getProviderAss()
    {
        return $this->providerAss;
    }
    /**
     * Set providerAss value
     * @param string $providerAss
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType
     */
    public function setProviderAss($providerAss = null)
    {
        // validation for constraint: pattern
        if (is_scalar($providerAss) && !preg_match('/[0-9]{1,5}/', $providerAss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{1,5}", "%s" given', var_export($providerAss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($providerAss) && !is_string($providerAss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($providerAss)), __LINE__);
        }
        $this->providerAss = $providerAss;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\AgentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
