<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Request ServiceType
 * @subpackage Services
 */
class Request extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named requestOffer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestOffer $requestOffer
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseOffer|bool
     */
    public function requestOffer(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestOffer $requestOffer)
    {
        try {
            $this->setResult(self::getSoapClient()->requestOffer($requestOffer));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named requestCancellation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestCancellation $requestCancellation
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseCancellation|bool
     */
    public function requestCancellation(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestCancellation $requestCancellation)
    {
        try {
            $this->setResult(self::getSoapClient()->requestCancellation($requestCancellation));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named requestBooking
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestBooking $requestBooking
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseBooking|bool
     */
    public function requestBooking(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestBooking $requestBooking)
    {
        try {
            $this->setResult(self::getSoapClient()->requestBooking($requestBooking));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named requestPreContractualInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestPreContractualInformation $requestPreContractualInformation
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponsePreContractualInformation|bool
     */
    public function requestPreContractualInformation(\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\RequestPreContractualInformation $requestPreContractualInformation)
    {
        try {
            $this->setResult(self::getSoapClient()->requestPreContractualInformation($requestPreContractualInformation));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseBooking|\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseCancellation|\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponseOffer|\Sio\Module\TourismInsuranceBundle\Model\ErvSoap\StructType\ResponsePreContractualInformation
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
