<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType;

/**
 * This class stands for TripTypeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: type for tripType [Typ fuer Verkehrsmitteltyp]
 * @subpackage Enumerations
 */
class TripTypeType
{
    /**
     * Constant for value 'BUS'
     * @return string 'BUS'
     */
    const VALUE_BUS = 'BUS';
    /**
     * Constant for value 'bus'
     * @return string 'bus'
     */
    const VALUE_BUS_1 = 'bus';
    /**
     * Constant for value 'CAR'
     * @return string 'CAR'
     */
    const VALUE_CAR = 'CAR';
    /**
     * Constant for value 'car'
     * @return string 'car'
     */
    const VALUE_CAR_1 = 'car';
    /**
     * Constant for value 'CRU'
     * @return string 'CRU'
     */
    const VALUE_CRU = 'CRU';
    /**
     * Constant for value 'cru'
     * @return string 'cru'
     */
    const VALUE_CRU_1 = 'cru';
    /**
     * Constant for value 'FLT'
     * @return string 'FLT'
     */
    const VALUE_FLT = 'FLT';
    /**
     * Constant for value 'flt'
     * @return string 'flt'
     */
    const VALUE_FLT_1 = 'flt';
    /**
     * Constant for value 'TRN'
     * @return string 'TRN'
     */
    const VALUE_TRN = 'TRN';
    /**
     * Constant for value 'trn'
     * @return string 'trn'
     */
    const VALUE_TRN_1 = 'trn';
    /**
     * Constant for value 'SCH'
     * @return string 'SCH'
     */
    const VALUE_SCH = 'SCH';
    /**
     * Constant for value 'sch'
     * @return string 'sch'
     */
    const VALUE_SCH_1 = 'sch';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BUS
     * @uses self::VALUE_BUS_1
     * @uses self::VALUE_CAR
     * @uses self::VALUE_CAR_1
     * @uses self::VALUE_CRU
     * @uses self::VALUE_CRU_1
     * @uses self::VALUE_FLT
     * @uses self::VALUE_FLT_1
     * @uses self::VALUE_TRN
     * @uses self::VALUE_TRN_1
     * @uses self::VALUE_SCH
     * @uses self::VALUE_SCH_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BUS,
            self::VALUE_BUS_1,
            self::VALUE_CAR,
            self::VALUE_CAR_1,
            self::VALUE_CRU,
            self::VALUE_CRU_1,
            self::VALUE_FLT,
            self::VALUE_FLT_1,
            self::VALUE_TRN,
            self::VALUE_TRN_1,
            self::VALUE_SCH,
            self::VALUE_SCH_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
