<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType;

/**
 * This class stands for tariffCategoryType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: type for tariffCategory [Typ fuer Tarif Kategorie,derzeit nur Rentals]
 * @subpackage Enumerations
 */
class TariffCategoryType
{
    /**
     * Constant for value 'AC'
     * @return string 'AC'
     */
    const VALUE_AC = 'AC';
    /**
     * Constant for value 'ac'
     * @return string 'ac'
     */
    const VALUE_AC_1 = 'ac';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AC
     * @uses self::VALUE_AC_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AC,
            self::VALUE_AC_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
