<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType;

/**
 * This class stands for paymentMethodType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: type for method of payment [Zahlungsweise]
 * @subpackage Enumerations
 */
class PaymentMethodType
{
    /**
     * Constant for value 'be'
     * @return string 'be'
     */
    const VALUE_BE = 'be';
    /**
     * Constant for value 'BE'
     * @return string 'BE'
     */
    const VALUE_BE_1 = 'BE';
    /**
     * Constant for value 'ai'
     * @return string 'ai'
     */
    const VALUE_AI = 'ai';
    /**
     * Constant for value 'AI'
     * @return string 'AI'
     */
    const VALUE_AI_1 = 'AI';
    /**
     * Constant for value 'kk'
     * @return string 'kk'
     */
    const VALUE_KK = 'kk';
    /**
     * Constant for value 'KK'
     * @return string 'KK'
     */
    const VALUE_KK_1 = 'KK';
    /**
     * Constant for value 'kx'
     * @return string 'kx'
     */
    const VALUE_KX = 'kx';
    /**
     * Constant for value 'KX'
     * @return string 'KX'
     */
    const VALUE_KX_1 = 'KX';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BE
     * @uses self::VALUE_BE_1
     * @uses self::VALUE_AI
     * @uses self::VALUE_AI_1
     * @uses self::VALUE_KK
     * @uses self::VALUE_KK_1
     * @uses self::VALUE_KX
     * @uses self::VALUE_KX_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BE,
            self::VALUE_BE_1,
            self::VALUE_AI,
            self::VALUE_AI_1,
            self::VALUE_KK,
            self::VALUE_KK_1,
            self::VALUE_KX,
            self::VALUE_KX_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
