<?php

namespace Sio\Module\TourismInsuranceBundle\Model\ErvSoap\EnumType;

/**
 * This class stands for addressCustomerType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: type for address [Typ fuer Anrede] | hr=mister [herr]
 * @subpackage Enumerations
 */
class AddressCustomerType
{
    /**
     * Constant for value 'hr'
     * @return string 'hr'
     */
    const VALUE_HR = 'hr';
    /**
     * Constant for value 'HR'
     * @return string 'HR'
     */
    const VALUE_HR_1 = 'HR';
    /**
     * Constant for value 'fr'
     * @return string 'fr'
     */
    const VALUE_FR = 'fr';
    /**
     * Constant for value 'FR'
     * @return string 'FR'
     */
    const VALUE_FR_1 = 'FR';
    /**
     * Constant for value 'fa'
     * @return string 'fa'
     */
    const VALUE_FA = 'fa';
    /**
     * Constant for value 'FA'
     * @return string 'FA'
     */
    const VALUE_FA_1 = 'FA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HR
     * @uses self::VALUE_HR_1
     * @uses self::VALUE_FR
     * @uses self::VALUE_FR_1
     * @uses self::VALUE_FA
     * @uses self::VALUE_FA_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HR,
            self::VALUE_HR_1,
            self::VALUE_FR,
            self::VALUE_FR_1,
            self::VALUE_FA,
            self::VALUE_FA_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
