<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for simpleOperationResult StructType
 * @subpackage Structs
 */
class SimpleOperationResult extends AbstractStructBase
{
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The resultCode
     * @var int
     */
    public $resultCode;
    /**
     * Constructor method for simpleOperationResult
     * @uses SimpleOperationResult::setMessage()
     * @uses SimpleOperationResult::setResultCode()
     * @param string $message
     * @param int $resultCode
     */
    public function __construct($message = null, $resultCode = null)
    {
        $this
            ->setMessage($message)
            ->setResultCode($resultCode);
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\SimpleOperationResult
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get resultCode value
     * @return int|null
     */
    public function getResultCode()
    {
        return $this->resultCode;
    }
    /**
     * Set resultCode value
     * @param int $resultCode
     * @return \StructType\SimpleOperationResult
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: int
        if (!is_null($resultCode) && !is_numeric($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($resultCode)), __LINE__);
        }
        $this->resultCode = $resultCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SimpleOperationResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
