<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getCustomers StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getCustomers
 * @subpackage Structs
 */
class GetCustomers extends AbstractStructBase
{
    /**
     * The requestedCustomers
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $requestedCustomers;
    /**
     * The options
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WsEntry[]
     */
    public $options;
    /**
     * The credentials
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Credentials
     */
    public $credentials;
    /**
     * Constructor method for getCustomers
     * @uses GetCustomers::setRequestedCustomers()
     * @uses GetCustomers::setOptions()
     * @uses GetCustomers::setCredentials()
     * @param string[] $requestedCustomers
     * @param \StructType\WsEntry[] $options
     * @param \StructType\Credentials $credentials
     */
    public function __construct(array $requestedCustomers = array(), array $options = array(), \StructType\Credentials $credentials = null)
    {
        $this
            ->setRequestedCustomers($requestedCustomers)
            ->setOptions($options)
            ->setCredentials($credentials);
    }
    /**
     * Get requestedCustomers value
     * @return string[]|null
     */
    public function getRequestedCustomers()
    {
        return $this->requestedCustomers;
    }
    /**
     * Set requestedCustomers value
     * @throws \InvalidArgumentException
     * @param string[] $requestedCustomers
     * @return \StructType\GetCustomers
     */
    public function setRequestedCustomers(array $requestedCustomers = array())
    {
        foreach ($requestedCustomers as $getCustomersRequestedCustomersItem) {
            // validation for constraint: itemType
            if (!is_string($getCustomersRequestedCustomersItem)) {
                throw new \InvalidArgumentException(sprintf('The requestedCustomers property can only contain items of string, "%s" given', is_object($getCustomersRequestedCustomersItem) ? get_class($getCustomersRequestedCustomersItem) : gettype($getCustomersRequestedCustomersItem)), __LINE__);
            }
        }
        $this->requestedCustomers = $requestedCustomers;
        return $this;
    }
    /**
     * Add item to requestedCustomers value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GetCustomers
     */
    public function addToRequestedCustomers($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The requestedCustomers property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->requestedCustomers[] = $item;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\WsEntry[]|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @throws \InvalidArgumentException
     * @param \StructType\WsEntry[] $options
     * @return \StructType\GetCustomers
     */
    public function setOptions(array $options = array())
    {
        foreach ($options as $getCustomersOptionsItem) {
            // validation for constraint: itemType
            if (!$getCustomersOptionsItem instanceof \StructType\WsEntry) {
                throw new \InvalidArgumentException(sprintf('The options property can only contain items of \StructType\WsEntry, "%s" given', is_object($getCustomersOptionsItem) ? get_class($getCustomersOptionsItem) : gettype($getCustomersOptionsItem)), __LINE__);
            }
        }
        $this->options = $options;
        return $this;
    }
    /**
     * Add item to options value
     * @throws \InvalidArgumentException
     * @param \StructType\WsEntry $item
     * @return \StructType\GetCustomers
     */
    public function addToOptions(\StructType\WsEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsEntry) {
            throw new \InvalidArgumentException(sprintf('The options property can only contain items of \StructType\WsEntry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->options[] = $item;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\Credentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\Credentials $credentials
     * @return \StructType\GetCustomers
     */
    public function setCredentials(\StructType\Credentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCustomers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
