<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for operationResult StructType
 * @subpackage Structs
 */
class OperationResult extends SimpleOperationResult
{
    /**
     * The warnings
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SimpleOperationResult[]
     */
    public $warnings;
    /**
     * Constructor method for operationResult
     * @uses OperationResult::setWarnings()
     * @param \StructType\SimpleOperationResult[] $warnings
     */
    public function __construct(array $warnings = array())
    {
        $this
            ->setWarnings($warnings);
    }
    /**
     * Get warnings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SimpleOperationResult[]|null
     */
    public function getWarnings()
    {
        return isset($this->warnings) ? $this->warnings : null;
    }
    /**
     * Set warnings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SimpleOperationResult[] $warnings
     * @return \StructType\OperationResult
     */
    public function setWarnings(array $warnings = array())
    {
        foreach ($warnings as $operationResultWarningsItem) {
            // validation for constraint: itemType
            if (!$operationResultWarningsItem instanceof \StructType\SimpleOperationResult) {
                throw new \InvalidArgumentException(sprintf('The warnings property can only contain items of \StructType\SimpleOperationResult, "%s" given', is_object($operationResultWarningsItem) ? get_class($operationResultWarningsItem) : gettype($operationResultWarningsItem)), __LINE__);
            }
        }
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->warnings);
        } else {
            $this->warnings = $warnings;
        }
        return $this;
    }
    /**
     * Add item to warnings value
     * @throws \InvalidArgumentException
     * @param \StructType\SimpleOperationResult $item
     * @return \StructType\OperationResult
     */
    public function addToWarnings(\StructType\SimpleOperationResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SimpleOperationResult) {
            throw new \InvalidArgumentException(sprintf('The warnings property can only contain items of \StructType\SimpleOperationResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->warnings[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OperationResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
