<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deleteAttachment StructType
 * Meta informations extracted from the WSDL
 * - type: tns:deleteAttachment
 * @subpackage Structs
 */
class DeleteAttachment extends AbstractStructBase
{
    /**
     * The attachment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Attachment
     */
    public $attachment;
    /**
     * The options
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WsEntry[]
     */
    public $options;
    /**
     * The credentials
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Credentials
     */
    public $credentials;
    /**
     * Constructor method for deleteAttachment
     * @uses DeleteAttachment::setAttachment()
     * @uses DeleteAttachment::setOptions()
     * @uses DeleteAttachment::setCredentials()
     * @param \StructType\Attachment $attachment
     * @param \StructType\WsEntry[] $options
     * @param \StructType\Credentials $credentials
     */
    public function __construct(\StructType\Attachment $attachment = null, array $options = array(), \StructType\Credentials $credentials = null)
    {
        $this
            ->setAttachment($attachment)
            ->setOptions($options)
            ->setCredentials($credentials);
    }
    /**
     * Get attachment value
     * @return \StructType\Attachment|null
     */
    public function getAttachment()
    {
        return $this->attachment;
    }
    /**
     * Set attachment value
     * @param \StructType\Attachment $attachment
     * @return \StructType\DeleteAttachment
     */
    public function setAttachment(\StructType\Attachment $attachment = null)
    {
        $this->attachment = $attachment;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\WsEntry[]|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @throws \InvalidArgumentException
     * @param \StructType\WsEntry[] $options
     * @return \StructType\DeleteAttachment
     */
    public function setOptions(array $options = array())
    {
        foreach ($options as $deleteAttachmentOptionsItem) {
            // validation for constraint: itemType
            if (!$deleteAttachmentOptionsItem instanceof \StructType\WsEntry) {
                throw new \InvalidArgumentException(sprintf('The options property can only contain items of \StructType\WsEntry, "%s" given', is_object($deleteAttachmentOptionsItem) ? get_class($deleteAttachmentOptionsItem) : gettype($deleteAttachmentOptionsItem)), __LINE__);
            }
        }
        $this->options = $options;
        return $this;
    }
    /**
     * Add item to options value
     * @throws \InvalidArgumentException
     * @param \StructType\WsEntry $item
     * @return \StructType\DeleteAttachment
     */
    public function addToOptions(\StructType\WsEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsEntry) {
            throw new \InvalidArgumentException(sprintf('The options property can only contain items of \StructType\WsEntry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->options[] = $item;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\Credentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\Credentials $credentials
     * @return \StructType\DeleteAttachment
     */
    public function setCredentials(\StructType\Credentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteAttachment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
