<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customersRequestResult StructType
 * @subpackage Structs
 */
class CustomersRequestResult extends EntitiesRequestResult
{
    /**
     * The entities
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Customer[]
     */
    public $entities;
    /**
     * Constructor method for customersRequestResult
     * @uses CustomersRequestResult::setEntities()
     * @param \StructType\Customer[] $entities
     */
    public function __construct(array $entities = array())
    {
        $this
            ->setEntities($entities);
    }
    /**
     * Get entities value
     * @return \StructType\Customer[]|null
     */
    public function getEntities()
    {
        return $this->entities;
    }
    /**
     * Set entities value
     * @throws \InvalidArgumentException
     * @param \StructType\Customer[] $entities
     * @return \StructType\CustomersRequestResult
     */
    public function setEntities(array $entities = array())
    {
        foreach ($entities as $customersRequestResultEntitiesItem) {
            // validation for constraint: itemType
            if (!$customersRequestResultEntitiesItem instanceof \StructType\Customer) {
                throw new \InvalidArgumentException(sprintf('The entities property can only contain items of \StructType\Customer, "%s" given', is_object($customersRequestResultEntitiesItem) ? get_class($customersRequestResultEntitiesItem) : gettype($customersRequestResultEntitiesItem)), __LINE__);
            }
        }
        $this->entities = $entities;
        return $this;
    }
    /**
     * Add item to entities value
     * @throws \InvalidArgumentException
     * @param \StructType\Customer $item
     * @return \StructType\CustomersRequestResult
     */
    public function addToEntities(\StructType\Customer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Customer) {
            throw new \InvalidArgumentException(sprintf('The entities property can only contain items of \StructType\Customer, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->entities[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomersRequestResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
