<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customer StructType
 * @subpackage Structs
 */
class Customer extends AbstractStructBase
{
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The city
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The contact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contact;
    /**
     * The contacts
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Contact[]
     */
    public $contacts;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The customAttributes
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WsValuedEntry[]
     */
    public $customAttributes;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WsValuedEntry[]
     */
    public $extensions;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The organizationalUnit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $organizationalUnit;
    /**
     * The zipCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $zipCode;
    /**
     * Constructor method for customer
     * @uses Customer::setAddress()
     * @uses Customer::setCity()
     * @uses Customer::setContact()
     * @uses Customer::setContacts()
     * @uses Customer::setCountry()
     * @uses Customer::setCustomAttributes()
     * @uses Customer::setDescription()
     * @uses Customer::setExtensions()
     * @uses Customer::setId()
     * @uses Customer::setName()
     * @uses Customer::setOrganizationalUnit()
     * @uses Customer::setZipCode()
     * @param string $address
     * @param string $city
     * @param string $contact
     * @param \StructType\Contact[] $contacts
     * @param string $country
     * @param \StructType\WsValuedEntry[] $customAttributes
     * @param string $description
     * @param \StructType\WsValuedEntry[] $extensions
     * @param string $id
     * @param string $name
     * @param string $organizationalUnit
     * @param string $zipCode
     */
    public function __construct($address = null, $city = null, $contact = null, array $contacts = array(), $country = null, array $customAttributes = array(), $description = null, array $extensions = array(), $id = null, $name = null, $organizationalUnit = null, $zipCode = null)
    {
        $this
            ->setAddress($address)
            ->setCity($city)
            ->setContact($contact)
            ->setContacts($contacts)
            ->setCountry($country)
            ->setCustomAttributes($customAttributes)
            ->setDescription($description)
            ->setExtensions($extensions)
            ->setId($id)
            ->setName($name)
            ->setOrganizationalUnit($organizationalUnit)
            ->setZipCode($zipCode);
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\Customer
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\Customer
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get contact value
     * @return string|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param string $contact
     * @return \StructType\Customer
     */
    public function setContact($contact = null)
    {
        // validation for constraint: string
        if (!is_null($contact) && !is_string($contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contact)), __LINE__);
        }
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get contacts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Contact[]|null
     */
    public function getContacts()
    {
        return isset($this->contacts) ? $this->contacts : null;
    }
    /**
     * Set contacts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Contact[] $contacts
     * @return \StructType\Customer
     */
    public function setContacts(array $contacts = array())
    {
        foreach ($contacts as $customerContactsItem) {
            // validation for constraint: itemType
            if (!$customerContactsItem instanceof \StructType\Contact) {
                throw new \InvalidArgumentException(sprintf('The contacts property can only contain items of \StructType\Contact, "%s" given', is_object($customerContactsItem) ? get_class($customerContactsItem) : gettype($customerContactsItem)), __LINE__);
            }
        }
        if (is_null($contacts) || (is_array($contacts) && empty($contacts))) {
            unset($this->contacts);
        } else {
            $this->contacts = $contacts;
        }
        return $this;
    }
    /**
     * Add item to contacts value
     * @throws \InvalidArgumentException
     * @param \StructType\Contact $item
     * @return \StructType\Customer
     */
    public function addToContacts(\StructType\Contact $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Contact) {
            throw new \InvalidArgumentException(sprintf('The contacts property can only contain items of \StructType\Contact, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->contacts[] = $item;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\Customer
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get customAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WsValuedEntry[]|null
     */
    public function getCustomAttributes()
    {
        return isset($this->customAttributes) ? $this->customAttributes : null;
    }
    /**
     * Set customAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WsValuedEntry[] $customAttributes
     * @return \StructType\Customer
     */
    public function setCustomAttributes(array $customAttributes = array())
    {
        foreach ($customAttributes as $customerCustomAttributesItem) {
            // validation for constraint: itemType
            if (!$customerCustomAttributesItem instanceof \StructType\WsValuedEntry) {
                throw new \InvalidArgumentException(sprintf('The customAttributes property can only contain items of \StructType\WsValuedEntry, "%s" given', is_object($customerCustomAttributesItem) ? get_class($customerCustomAttributesItem) : gettype($customerCustomAttributesItem)), __LINE__);
            }
        }
        if (is_null($customAttributes) || (is_array($customAttributes) && empty($customAttributes))) {
            unset($this->customAttributes);
        } else {
            $this->customAttributes = $customAttributes;
        }
        return $this;
    }
    /**
     * Add item to customAttributes value
     * @throws \InvalidArgumentException
     * @param \StructType\WsValuedEntry $item
     * @return \StructType\Customer
     */
    public function addToCustomAttributes(\StructType\WsValuedEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsValuedEntry) {
            throw new \InvalidArgumentException(sprintf('The customAttributes property can only contain items of \StructType\WsValuedEntry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->customAttributes[] = $item;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Customer
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get extensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WsValuedEntry[]|null
     */
    public function getExtensions()
    {
        return isset($this->extensions) ? $this->extensions : null;
    }
    /**
     * Set extensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WsValuedEntry[] $extensions
     * @return \StructType\Customer
     */
    public function setExtensions(array $extensions = array())
    {
        foreach ($extensions as $customerExtensionsItem) {
            // validation for constraint: itemType
            if (!$customerExtensionsItem instanceof \StructType\WsValuedEntry) {
                throw new \InvalidArgumentException(sprintf('The extensions property can only contain items of \StructType\WsValuedEntry, "%s" given', is_object($customerExtensionsItem) ? get_class($customerExtensionsItem) : gettype($customerExtensionsItem)), __LINE__);
            }
        }
        if (is_null($extensions) || (is_array($extensions) && empty($extensions))) {
            unset($this->extensions);
        } else {
            $this->extensions = $extensions;
        }
        return $this;
    }
    /**
     * Add item to extensions value
     * @throws \InvalidArgumentException
     * @param \StructType\WsValuedEntry $item
     * @return \StructType\Customer
     */
    public function addToExtensions(\StructType\WsValuedEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsValuedEntry) {
            throw new \InvalidArgumentException(sprintf('The extensions property can only contain items of \StructType\WsValuedEntry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->extensions[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Customer
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Customer
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get organizationalUnit value
     * @return string|null
     */
    public function getOrganizationalUnit()
    {
        return $this->organizationalUnit;
    }
    /**
     * Set organizationalUnit value
     * @param string $organizationalUnit
     * @return \StructType\Customer
     */
    public function setOrganizationalUnit($organizationalUnit = null)
    {
        // validation for constraint: string
        if (!is_null($organizationalUnit) && !is_string($organizationalUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organizationalUnit)), __LINE__);
        }
        $this->organizationalUnit = $organizationalUnit;
        return $this;
    }
    /**
     * Get zipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->zipCode;
    }
    /**
     * Set zipCode value
     * @param string $zipCode
     * @return \StructType\Customer
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        $this->zipCode = $zipCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Customer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
