<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for entitiesCreationResult StructType
 * @subpackage Structs
 */
class EntitiesCreationResult extends OperationResult
{
    /**
     * The results
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EntityCreationResult[]
     */
    public $results;
    /**
     * Constructor method for entitiesCreationResult
     * @uses EntitiesCreationResult::setResults()
     * @param \StructType\EntityCreationResult[] $results
     */
    public function __construct(array $results = array())
    {
        $this
            ->setResults($results);
    }
    /**
     * Get results value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EntityCreationResult[]|null
     */
    public function getResults()
    {
        return isset($this->results) ? $this->results : null;
    }
    /**
     * Set results value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EntityCreationResult[] $results
     * @return \StructType\EntitiesCreationResult
     */
    public function setResults(array $results = array())
    {
        foreach ($results as $entitiesCreationResultResultsItem) {
            // validation for constraint: itemType
            if (!$entitiesCreationResultResultsItem instanceof \StructType\EntityCreationResult) {
                throw new \InvalidArgumentException(sprintf('The results property can only contain items of \StructType\EntityCreationResult, "%s" given', is_object($entitiesCreationResultResultsItem) ? get_class($entitiesCreationResultResultsItem) : gettype($entitiesCreationResultResultsItem)), __LINE__);
            }
        }
        if (is_null($results) || (is_array($results) && empty($results))) {
            unset($this->results);
        } else {
            $this->results = $results;
        }
        return $this;
    }
    /**
     * Add item to results value
     * @throws \InvalidArgumentException
     * @param \StructType\EntityCreationResult $item
     * @return \StructType\EntitiesCreationResult
     */
    public function addToResults(\StructType\EntityCreationResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EntityCreationResult) {
            throw new \InvalidArgumentException(sprintf('The results property can only contain items of \StructType\EntityCreationResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->results[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EntitiesCreationResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
