<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deleteCustomers StructType
 * Meta informations extracted from the WSDL
 * - type: tns:deleteCustomers
 * @subpackage Structs
 */
class DeleteCustomers extends AbstractStructBase
{
    /**
     * The customersToDelete
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $customersToDelete;
    /**
     * The options
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WsEntry[]
     */
    public $options;
    /**
     * The credentials
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Credentials
     */
    public $credentials;
    /**
     * Constructor method for deleteCustomers
     * @uses DeleteCustomers::setCustomersToDelete()
     * @uses DeleteCustomers::setOptions()
     * @uses DeleteCustomers::setCredentials()
     * @param string[] $customersToDelete
     * @param \StructType\WsEntry[] $options
     * @param \StructType\Credentials $credentials
     */
    public function __construct(array $customersToDelete = array(), array $options = array(), \StructType\Credentials $credentials = null)
    {
        $this
            ->setCustomersToDelete($customersToDelete)
            ->setOptions($options)
            ->setCredentials($credentials);
    }
    /**
     * Get customersToDelete value
     * @return string[]|null
     */
    public function getCustomersToDelete()
    {
        return $this->customersToDelete;
    }
    /**
     * Set customersToDelete value
     * @throws \InvalidArgumentException
     * @param string[] $customersToDelete
     * @return \StructType\DeleteCustomers
     */
    public function setCustomersToDelete(array $customersToDelete = array())
    {
        foreach ($customersToDelete as $deleteCustomersCustomersToDeleteItem) {
            // validation for constraint: itemType
            if (!is_string($deleteCustomersCustomersToDeleteItem)) {
                throw new \InvalidArgumentException(sprintf('The customersToDelete property can only contain items of string, "%s" given', is_object($deleteCustomersCustomersToDeleteItem) ? get_class($deleteCustomersCustomersToDeleteItem) : gettype($deleteCustomersCustomersToDeleteItem)), __LINE__);
            }
        }
        $this->customersToDelete = $customersToDelete;
        return $this;
    }
    /**
     * Add item to customersToDelete value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DeleteCustomers
     */
    public function addToCustomersToDelete($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The customersToDelete property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->customersToDelete[] = $item;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\WsEntry[]|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @throws \InvalidArgumentException
     * @param \StructType\WsEntry[] $options
     * @return \StructType\DeleteCustomers
     */
    public function setOptions(array $options = array())
    {
        foreach ($options as $deleteCustomersOptionsItem) {
            // validation for constraint: itemType
            if (!$deleteCustomersOptionsItem instanceof \StructType\WsEntry) {
                throw new \InvalidArgumentException(sprintf('The options property can only contain items of \StructType\WsEntry, "%s" given', is_object($deleteCustomersOptionsItem) ? get_class($deleteCustomersOptionsItem) : gettype($deleteCustomersOptionsItem)), __LINE__);
            }
        }
        $this->options = $options;
        return $this;
    }
    /**
     * Add item to options value
     * @throws \InvalidArgumentException
     * @param \StructType\WsEntry $item
     * @return \StructType\DeleteCustomers
     */
    public function addToOptions(\StructType\WsEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsEntry) {
            throw new \InvalidArgumentException(sprintf('The options property can only contain items of \StructType\WsEntry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->options[] = $item;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\Credentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\Credentials $credentials
     * @return \StructType\DeleteCustomers
     */
    public function setCredentials(\StructType\Credentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteCustomers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
