<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createCustomers StructType
 * Meta informations extracted from the WSDL
 * - type: tns:createCustomers
 * @subpackage Structs
 */
class CreateCustomers extends AbstractStructBase
{
    /**
     * The customers
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Customer[]
     */
    public $customers;
    /**
     * The options
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WsEntry[]
     */
    public $options;
    /**
     * The credentials
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Credentials
     */
    public $credentials;
    /**
     * Constructor method for createCustomers
     * @uses CreateCustomers::setCustomers()
     * @uses CreateCustomers::setOptions()
     * @uses CreateCustomers::setCredentials()
     * @param \StructType\Customer[] $customers
     * @param \StructType\WsEntry[] $options
     * @param \StructType\Credentials $credentials
     */
    public function __construct(array $customers = array(), array $options = array(), \StructType\Credentials $credentials = null)
    {
        $this
            ->setCustomers($customers)
            ->setOptions($options)
            ->setCredentials($credentials);
    }
    /**
     * Get customers value
     * @return \StructType\Customer[]|null
     */
    public function getCustomers()
    {
        return $this->customers;
    }
    /**
     * Set customers value
     * @throws \InvalidArgumentException
     * @param \StructType\Customer[] $customers
     * @return \StructType\CreateCustomers
     */
    public function setCustomers(array $customers = array())
    {
        foreach ($customers as $createCustomersCustomersItem) {
            // validation for constraint: itemType
            if (!$createCustomersCustomersItem instanceof \StructType\Customer) {
                throw new \InvalidArgumentException(sprintf('The customers property can only contain items of \StructType\Customer, "%s" given', is_object($createCustomersCustomersItem) ? get_class($createCustomersCustomersItem) : gettype($createCustomersCustomersItem)), __LINE__);
            }
        }
        $this->customers = $customers;
        return $this;
    }
    /**
     * Add item to customers value
     * @throws \InvalidArgumentException
     * @param \StructType\Customer $item
     * @return \StructType\CreateCustomers
     */
    public function addToCustomers(\StructType\Customer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Customer) {
            throw new \InvalidArgumentException(sprintf('The customers property can only contain items of \StructType\Customer, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->customers[] = $item;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\WsEntry[]|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @throws \InvalidArgumentException
     * @param \StructType\WsEntry[] $options
     * @return \StructType\CreateCustomers
     */
    public function setOptions(array $options = array())
    {
        foreach ($options as $createCustomersOptionsItem) {
            // validation for constraint: itemType
            if (!$createCustomersOptionsItem instanceof \StructType\WsEntry) {
                throw new \InvalidArgumentException(sprintf('The options property can only contain items of \StructType\WsEntry, "%s" given', is_object($createCustomersOptionsItem) ? get_class($createCustomersOptionsItem) : gettype($createCustomersOptionsItem)), __LINE__);
            }
        }
        $this->options = $options;
        return $this;
    }
    /**
     * Add item to options value
     * @throws \InvalidArgumentException
     * @param \StructType\WsEntry $item
     * @return \StructType\CreateCustomers
     */
    public function addToOptions(\StructType\WsEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsEntry) {
            throw new \InvalidArgumentException(sprintf('The options property can only contain items of \StructType\WsEntry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->options[] = $item;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\Credentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\Credentials $credentials
     * @return \StructType\CreateCustomers
     */
    public function setCredentials(\StructType\Credentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateCustomers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
