<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createAttachment StructType
 * Meta informations extracted from the WSDL
 * - type: tns:createAttachment
 * @subpackage Structs
 */
class CreateAttachment extends AbstractStructBase
{
    /**
     * The attachment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Attachment
     */
    public $attachment;
    /**
     * The stream
     * Meta informations extracted from the WSDL
     * - expectedContentTypes: application/octet-stream
     * - minOccurs: 0
     * @var string
     */
    public $stream;
    /**
     * The options
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WsEntry[]
     */
    public $options;
    /**
     * The credentials
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Credentials
     */
    public $credentials;
    /**
     * Constructor method for createAttachment
     * @uses CreateAttachment::setAttachment()
     * @uses CreateAttachment::setStream()
     * @uses CreateAttachment::setOptions()
     * @uses CreateAttachment::setCredentials()
     * @param \StructType\Attachment $attachment
     * @param string $stream
     * @param \StructType\WsEntry[] $options
     * @param \StructType\Credentials $credentials
     */
    public function __construct(\StructType\Attachment $attachment = null, $stream = null, array $options = array(), \StructType\Credentials $credentials = null)
    {
        $this
            ->setAttachment($attachment)
            ->setStream($stream)
            ->setOptions($options)
            ->setCredentials($credentials);
    }
    /**
     * Get attachment value
     * @return \StructType\Attachment|null
     */
    public function getAttachment()
    {
        return $this->attachment;
    }
    /**
     * Set attachment value
     * @param \StructType\Attachment $attachment
     * @return \StructType\CreateAttachment
     */
    public function setAttachment(\StructType\Attachment $attachment = null)
    {
        $this->attachment = $attachment;
        return $this;
    }
    /**
     * Get stream value
     * @return string|null
     */
    public function getStream()
    {
        return $this->stream;
    }
    /**
     * Set stream value
     * @param string $stream
     * @return \StructType\CreateAttachment
     */
    public function setStream($stream = null)
    {
        // validation for constraint: string
        if (!is_null($stream) && !is_string($stream)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stream)), __LINE__);
        }
        $this->stream = $stream;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\WsEntry[]|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @throws \InvalidArgumentException
     * @param \StructType\WsEntry[] $options
     * @return \StructType\CreateAttachment
     */
    public function setOptions(array $options = array())
    {
        foreach ($options as $createAttachmentOptionsItem) {
            // validation for constraint: itemType
            if (!$createAttachmentOptionsItem instanceof \StructType\WsEntry) {
                throw new \InvalidArgumentException(sprintf('The options property can only contain items of \StructType\WsEntry, "%s" given', is_object($createAttachmentOptionsItem) ? get_class($createAttachmentOptionsItem) : gettype($createAttachmentOptionsItem)), __LINE__);
            }
        }
        $this->options = $options;
        return $this;
    }
    /**
     * Add item to options value
     * @throws \InvalidArgumentException
     * @param \StructType\WsEntry $item
     * @return \StructType\CreateAttachment
     */
    public function addToOptions(\StructType\WsEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WsEntry) {
            throw new \InvalidArgumentException(sprintf('The options property can only contain items of \StructType\WsEntry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->options[] = $item;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\Credentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\Credentials $credentials
     * @return \StructType\CreateAttachment
     */
    public function setCredentials(\StructType\Credentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateAttachment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
