<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PositionTraceExternalId StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PositionTraceExternalId
 * @subpackage Structs
 */
class PositionTraceExternalId extends AbstractStructBase
{
    /**
     * The Bearing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Bearing;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The ExternalId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ExternalId;
    /**
     * The FuelLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FuelLevel;
    /**
     * The Ignition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Ignition;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Longitude;
    /**
     * The Speed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Speed;
    /**
     * The Town
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Town;
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Weight;
    /**
     * Constructor method for PositionTraceExternalId
     * @uses PositionTraceExternalId::setBearing()
     * @uses PositionTraceExternalId::setDate()
     * @uses PositionTraceExternalId::setExternalId()
     * @uses PositionTraceExternalId::setFuelLevel()
     * @uses PositionTraceExternalId::setIgnition()
     * @uses PositionTraceExternalId::setLatitude()
     * @uses PositionTraceExternalId::setLongitude()
     * @uses PositionTraceExternalId::setSpeed()
     * @uses PositionTraceExternalId::setTown()
     * @uses PositionTraceExternalId::setWeight()
     * @param int $bearing
     * @param string $date
     * @param int $externalId
     * @param int $fuelLevel
     * @param bool $ignition
     * @param float $latitude
     * @param float $longitude
     * @param int $speed
     * @param string $town
     * @param int $weight
     */
    public function __construct($bearing = null, $date = null, $externalId = null, $fuelLevel = null, $ignition = null, $latitude = null, $longitude = null, $speed = null, $town = null, $weight = null)
    {
        $this
            ->setBearing($bearing)
            ->setDate($date)
            ->setExternalId($externalId)
            ->setFuelLevel($fuelLevel)
            ->setIgnition($ignition)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setSpeed($speed)
            ->setTown($town)
            ->setWeight($weight);
    }
    /**
     * Get Bearing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBearing()
    {
        return isset($this->Bearing) ? $this->Bearing : null;
    }
    /**
     * Set Bearing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bearing
     * @return \StructType\PositionTraceExternalId
     */
    public function setBearing($bearing = null)
    {
        // validation for constraint: int
        if (!is_null($bearing) && !is_numeric($bearing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bearing)), __LINE__);
        }
        if (is_null($bearing) || (is_array($bearing) && empty($bearing))) {
            unset($this->Bearing);
        } else {
            $this->Bearing = $bearing;
        }
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\PositionTraceExternalId
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get ExternalId value
     * @return int|null
     */
    public function getExternalId()
    {
        return $this->ExternalId;
    }
    /**
     * Set ExternalId value
     * @param int $externalId
     * @return \StructType\PositionTraceExternalId
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: int
        if (!is_null($externalId) && !is_numeric($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($externalId)), __LINE__);
        }
        $this->ExternalId = $externalId;
        return $this;
    }
    /**
     * Get FuelLevel value
     * @return int|null
     */
    public function getFuelLevel()
    {
        return $this->FuelLevel;
    }
    /**
     * Set FuelLevel value
     * @param int $fuelLevel
     * @return \StructType\PositionTraceExternalId
     */
    public function setFuelLevel($fuelLevel = null)
    {
        // validation for constraint: int
        if (!is_null($fuelLevel) && !is_numeric($fuelLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fuelLevel)), __LINE__);
        }
        $this->FuelLevel = $fuelLevel;
        return $this;
    }
    /**
     * Get Ignition value
     * @return bool|null
     */
    public function getIgnition()
    {
        return $this->Ignition;
    }
    /**
     * Set Ignition value
     * @param bool $ignition
     * @return \StructType\PositionTraceExternalId
     */
    public function setIgnition($ignition = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignition) && !is_bool($ignition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($ignition)), __LINE__);
        }
        $this->Ignition = $ignition;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\PositionTraceExternalId
     */
    public function setLatitude($latitude = null)
    {
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\PositionTraceExternalId
     */
    public function setLongitude($longitude = null)
    {
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Speed value
     * @return int|null
     */
    public function getSpeed()
    {
        return $this->Speed;
    }
    /**
     * Set Speed value
     * @param int $speed
     * @return \StructType\PositionTraceExternalId
     */
    public function setSpeed($speed = null)
    {
        // validation for constraint: int
        if (!is_null($speed) && !is_numeric($speed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($speed)), __LINE__);
        }
        $this->Speed = $speed;
        return $this;
    }
    /**
     * Get Town value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTown()
    {
        return isset($this->Town) ? $this->Town : null;
    }
    /**
     * Set Town value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $town
     * @return \StructType\PositionTraceExternalId
     */
    public function setTown($town = null)
    {
        // validation for constraint: string
        if (!is_null($town) && !is_string($town)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($town)), __LINE__);
        }
        if (is_null($town) || (is_array($town) && empty($town))) {
            unset($this->Town);
        } else {
            $this->Town = $town;
        }
        return $this;
    }
    /**
     * Get Weight value
     * @return int|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param int $weight
     * @return \StructType\PositionTraceExternalId
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: int
        if (!is_null($weight) && !is_numeric($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PositionTraceExternalId
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
