<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DtoTrackTransportWs StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DtoTrackTransportWs
 * @subpackage Structs
 */
class DtoTrackTransportWs extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The Billing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Billing;
    /**
     * The CarrierId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CarrierId;
    /**
     * The CarrierName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CarrierName;
    /**
     * The Chain
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Chain;
    /**
     * The ClientId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ClientId;
    /**
     * The ClientName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The DelayEnum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DelayEnum;
    /**
     * The Expedition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Expedition;
    /**
     * The Extra
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Extra;
    /**
     * The HasDocuments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HasDocuments;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Observation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Observation;
    /**
     * The PlateNotDefined
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PlateNotDefined;
    /**
     * The Rotation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Rotation;
    /**
     * The RouteDestination
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RouteDestination;
    /**
     * The RouteId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RouteId;
    /**
     * The RouteName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RouteName;
    /**
     * The RouteOrigin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RouteOrigin;
    /**
     * The ServiceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ServiceType;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The TrackActivities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDtoTrackActivityWs
     */
    public $TrackActivities;
    /**
     * The TrackIncidences
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDtoTrackIncidenceWs
     */
    public $TrackIncidences;
    /**
     * The TrackNotifications
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDtoTrackNotificationWs
     */
    public $TrackNotifications;
    /**
     * The TrackTransportPointControls
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDtoTrackTransportPointControlWs
     */
    public $TrackTransportPointControls;
    /**
     * The TrailerPlates
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $TrailerPlates;
    /**
     * The TrailerType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TrailerType;
    /**
     * The Transit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Transit;
    /**
     * The TruckPlates
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $TruckPlates;
    /**
     * The Week
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Week;
    /**
     * The Year
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Year;
    /**
     * The highIncidences
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $highIncidences;
    /**
     * Constructor method for DtoTrackTransportWs
     * @uses DtoTrackTransportWs::setAmount()
     * @uses DtoTrackTransportWs::setBilling()
     * @uses DtoTrackTransportWs::setCarrierId()
     * @uses DtoTrackTransportWs::setCarrierName()
     * @uses DtoTrackTransportWs::setChain()
     * @uses DtoTrackTransportWs::setClientId()
     * @uses DtoTrackTransportWs::setClientName()
     * @uses DtoTrackTransportWs::setDelayEnum()
     * @uses DtoTrackTransportWs::setExpedition()
     * @uses DtoTrackTransportWs::setExtra()
     * @uses DtoTrackTransportWs::setHasDocuments()
     * @uses DtoTrackTransportWs::setId()
     * @uses DtoTrackTransportWs::setObservation()
     * @uses DtoTrackTransportWs::setPlateNotDefined()
     * @uses DtoTrackTransportWs::setRotation()
     * @uses DtoTrackTransportWs::setRouteDestination()
     * @uses DtoTrackTransportWs::setRouteId()
     * @uses DtoTrackTransportWs::setRouteName()
     * @uses DtoTrackTransportWs::setRouteOrigin()
     * @uses DtoTrackTransportWs::setServiceType()
     * @uses DtoTrackTransportWs::setStatus()
     * @uses DtoTrackTransportWs::setTrackActivities()
     * @uses DtoTrackTransportWs::setTrackIncidences()
     * @uses DtoTrackTransportWs::setTrackNotifications()
     * @uses DtoTrackTransportWs::setTrackTransportPointControls()
     * @uses DtoTrackTransportWs::setTrailerPlates()
     * @uses DtoTrackTransportWs::setTrailerType()
     * @uses DtoTrackTransportWs::setTransit()
     * @uses DtoTrackTransportWs::setTruckPlates()
     * @uses DtoTrackTransportWs::setWeek()
     * @uses DtoTrackTransportWs::setYear()
     * @uses DtoTrackTransportWs::setHighIncidences()
     * @param float $amount
     * @param string $billing
     * @param int $carrierId
     * @param string $carrierName
     * @param string $chain
     * @param int $clientId
     * @param string $clientName
     * @param string $delayEnum
     * @param string $expedition
     * @param float $extra
     * @param string $hasDocuments
     * @param int $id
     * @param string $observation
     * @param bool $plateNotDefined
     * @param int $rotation
     * @param string $routeDestination
     * @param int $routeId
     * @param string $routeName
     * @param string $routeOrigin
     * @param string $serviceType
     * @param string $status
     * @param \ArrayType\ArrayOfDtoTrackActivityWs $trackActivities
     * @param \ArrayType\ArrayOfDtoTrackIncidenceWs $trackIncidences
     * @param \ArrayType\ArrayOfDtoTrackNotificationWs $trackNotifications
     * @param \ArrayType\ArrayOfDtoTrackTransportPointControlWs $trackTransportPointControls
     * @param \ArrayType\ArrayOfstring $trailerPlates
     * @param string $trailerType
     * @param string $transit
     * @param \ArrayType\ArrayOfstring $truckPlates
     * @param int $week
     * @param int $year
     * @param bool $highIncidences
     */
    public function __construct($amount = null, $billing = null, $carrierId = null, $carrierName = null, $chain = null, $clientId = null, $clientName = null, $delayEnum = null, $expedition = null, $extra = null, $hasDocuments = null, $id = null, $observation = null, $plateNotDefined = null, $rotation = null, $routeDestination = null, $routeId = null, $routeName = null, $routeOrigin = null, $serviceType = null, $status = null, \ArrayType\ArrayOfDtoTrackActivityWs $trackActivities = null, \ArrayType\ArrayOfDtoTrackIncidenceWs $trackIncidences = null, \ArrayType\ArrayOfDtoTrackNotificationWs $trackNotifications = null, \ArrayType\ArrayOfDtoTrackTransportPointControlWs $trackTransportPointControls = null, \ArrayType\ArrayOfstring $trailerPlates = null, $trailerType = null, $transit = null, \ArrayType\ArrayOfstring $truckPlates = null, $week = null, $year = null, $highIncidences = null)
    {
        $this
            ->setAmount($amount)
            ->setBilling($billing)
            ->setCarrierId($carrierId)
            ->setCarrierName($carrierName)
            ->setChain($chain)
            ->setClientId($clientId)
            ->setClientName($clientName)
            ->setDelayEnum($delayEnum)
            ->setExpedition($expedition)
            ->setExtra($extra)
            ->setHasDocuments($hasDocuments)
            ->setId($id)
            ->setObservation($observation)
            ->setPlateNotDefined($plateNotDefined)
            ->setRotation($rotation)
            ->setRouteDestination($routeDestination)
            ->setRouteId($routeId)
            ->setRouteName($routeName)
            ->setRouteOrigin($routeOrigin)
            ->setServiceType($serviceType)
            ->setStatus($status)
            ->setTrackActivities($trackActivities)
            ->setTrackIncidences($trackIncidences)
            ->setTrackNotifications($trackNotifications)
            ->setTrackTransportPointControls($trackTransportPointControls)
            ->setTrailerPlates($trailerPlates)
            ->setTrailerType($trailerType)
            ->setTransit($transit)
            ->setTruckPlates($truckPlates)
            ->setWeek($week)
            ->setYear($year)
            ->setHighIncidences($highIncidences);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\DtoTrackTransportWs
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Billing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBilling()
    {
        return isset($this->Billing) ? $this->Billing : null;
    }
    /**
     * Set Billing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $billing
     * @return \StructType\DtoTrackTransportWs
     */
    public function setBilling($billing = null)
    {
        // validation for constraint: string
        if (!is_null($billing) && !is_string($billing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billing)), __LINE__);
        }
        if (is_null($billing) || (is_array($billing) && empty($billing))) {
            unset($this->Billing);
        } else {
            $this->Billing = $billing;
        }
        return $this;
    }
    /**
     * Get CarrierId value
     * @return int|null
     */
    public function getCarrierId()
    {
        return $this->CarrierId;
    }
    /**
     * Set CarrierId value
     * @param int $carrierId
     * @return \StructType\DtoTrackTransportWs
     */
    public function setCarrierId($carrierId = null)
    {
        // validation for constraint: int
        if (!is_null($carrierId) && !is_numeric($carrierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($carrierId)), __LINE__);
        }
        $this->CarrierId = $carrierId;
        return $this;
    }
    /**
     * Get CarrierName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCarrierName()
    {
        return isset($this->CarrierName) ? $this->CarrierName : null;
    }
    /**
     * Set CarrierName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $carrierName
     * @return \StructType\DtoTrackTransportWs
     */
    public function setCarrierName($carrierName = null)
    {
        // validation for constraint: string
        if (!is_null($carrierName) && !is_string($carrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierName)), __LINE__);
        }
        if (is_null($carrierName) || (is_array($carrierName) && empty($carrierName))) {
            unset($this->CarrierName);
        } else {
            $this->CarrierName = $carrierName;
        }
        return $this;
    }
    /**
     * Get Chain value
     * @return string|null
     */
    public function getChain()
    {
        return $this->Chain;
    }
    /**
     * Set Chain value
     * @uses \EnumType\ChainEnum::valueIsValid()
     * @uses \EnumType\ChainEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $chain
     * @return \StructType\DtoTrackTransportWs
     */
    public function setChain($chain = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ChainEnum::valueIsValid($chain)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $chain, implode(', ', \EnumType\ChainEnum::getValidValues())), __LINE__);
        }
        $this->Chain = $chain;
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $clientId
     * @return \StructType\DtoTrackTransportWs
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: int
        if (!is_null($clientId) && !is_numeric($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($clientId)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \StructType\DtoTrackTransportWs
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get DelayEnum value
     * @return string|null
     */
    public function getDelayEnum()
    {
        return $this->DelayEnum;
    }
    /**
     * Set DelayEnum value
     * @uses \EnumType\DelayEnum::valueIsValid()
     * @uses \EnumType\DelayEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $delayEnum
     * @return \StructType\DtoTrackTransportWs
     */
    public function setDelayEnum($delayEnum = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DelayEnum::valueIsValid($delayEnum)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $delayEnum, implode(', ', \EnumType\DelayEnum::getValidValues())), __LINE__);
        }
        $this->DelayEnum = $delayEnum;
        return $this;
    }
    /**
     * Get Expedition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpedition()
    {
        return isset($this->Expedition) ? $this->Expedition : null;
    }
    /**
     * Set Expedition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expedition
     * @return \StructType\DtoTrackTransportWs
     */
    public function setExpedition($expedition = null)
    {
        // validation for constraint: string
        if (!is_null($expedition) && !is_string($expedition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expedition)), __LINE__);
        }
        if (is_null($expedition) || (is_array($expedition) && empty($expedition))) {
            unset($this->Expedition);
        } else {
            $this->Expedition = $expedition;
        }
        return $this;
    }
    /**
     * Get Extra value
     * @return float|null
     */
    public function getExtra()
    {
        return $this->Extra;
    }
    /**
     * Set Extra value
     * @param float $extra
     * @return \StructType\DtoTrackTransportWs
     */
    public function setExtra($extra = null)
    {
        $this->Extra = $extra;
        return $this;
    }
    /**
     * Get HasDocuments value
     * @return string|null
     */
    public function getHasDocuments()
    {
        return $this->HasDocuments;
    }
    /**
     * Set HasDocuments value
     * @uses \EnumType\FileTypeEnum::valueIsValid()
     * @uses \EnumType\FileTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hasDocuments
     * @return \StructType\DtoTrackTransportWs
     */
    public function setHasDocuments($hasDocuments = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FileTypeEnum::valueIsValid($hasDocuments)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $hasDocuments, implode(', ', \EnumType\FileTypeEnum::getValidValues())), __LINE__);
        }
        $this->HasDocuments = $hasDocuments;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\DtoTrackTransportWs
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Observation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObservation()
    {
        return isset($this->Observation) ? $this->Observation : null;
    }
    /**
     * Set Observation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $observation
     * @return \StructType\DtoTrackTransportWs
     */
    public function setObservation($observation = null)
    {
        // validation for constraint: string
        if (!is_null($observation) && !is_string($observation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($observation)), __LINE__);
        }
        if (is_null($observation) || (is_array($observation) && empty($observation))) {
            unset($this->Observation);
        } else {
            $this->Observation = $observation;
        }
        return $this;
    }
    /**
     * Get PlateNotDefined value
     * @return bool|null
     */
    public function getPlateNotDefined()
    {
        return $this->PlateNotDefined;
    }
    /**
     * Set PlateNotDefined value
     * @param bool $plateNotDefined
     * @return \StructType\DtoTrackTransportWs
     */
    public function setPlateNotDefined($plateNotDefined = null)
    {
        // validation for constraint: boolean
        if (!is_null($plateNotDefined) && !is_bool($plateNotDefined)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($plateNotDefined)), __LINE__);
        }
        $this->PlateNotDefined = $plateNotDefined;
        return $this;
    }
    /**
     * Get Rotation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRotation()
    {
        return isset($this->Rotation) ? $this->Rotation : null;
    }
    /**
     * Set Rotation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rotation
     * @return \StructType\DtoTrackTransportWs
     */
    public function setRotation($rotation = null)
    {
        // validation for constraint: int
        if (!is_null($rotation) && !is_numeric($rotation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rotation)), __LINE__);
        }
        if (is_null($rotation) || (is_array($rotation) && empty($rotation))) {
            unset($this->Rotation);
        } else {
            $this->Rotation = $rotation;
        }
        return $this;
    }
    /**
     * Get RouteDestination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRouteDestination()
    {
        return isset($this->RouteDestination) ? $this->RouteDestination : null;
    }
    /**
     * Set RouteDestination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routeDestination
     * @return \StructType\DtoTrackTransportWs
     */
    public function setRouteDestination($routeDestination = null)
    {
        // validation for constraint: string
        if (!is_null($routeDestination) && !is_string($routeDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeDestination)), __LINE__);
        }
        if (is_null($routeDestination) || (is_array($routeDestination) && empty($routeDestination))) {
            unset($this->RouteDestination);
        } else {
            $this->RouteDestination = $routeDestination;
        }
        return $this;
    }
    /**
     * Get RouteId value
     * @return int|null
     */
    public function getRouteId()
    {
        return $this->RouteId;
    }
    /**
     * Set RouteId value
     * @param int $routeId
     * @return \StructType\DtoTrackTransportWs
     */
    public function setRouteId($routeId = null)
    {
        // validation for constraint: int
        if (!is_null($routeId) && !is_numeric($routeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($routeId)), __LINE__);
        }
        $this->RouteId = $routeId;
        return $this;
    }
    /**
     * Get RouteName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRouteName()
    {
        return isset($this->RouteName) ? $this->RouteName : null;
    }
    /**
     * Set RouteName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routeName
     * @return \StructType\DtoTrackTransportWs
     */
    public function setRouteName($routeName = null)
    {
        // validation for constraint: string
        if (!is_null($routeName) && !is_string($routeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeName)), __LINE__);
        }
        if (is_null($routeName) || (is_array($routeName) && empty($routeName))) {
            unset($this->RouteName);
        } else {
            $this->RouteName = $routeName;
        }
        return $this;
    }
    /**
     * Get RouteOrigin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRouteOrigin()
    {
        return isset($this->RouteOrigin) ? $this->RouteOrigin : null;
    }
    /**
     * Set RouteOrigin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routeOrigin
     * @return \StructType\DtoTrackTransportWs
     */
    public function setRouteOrigin($routeOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($routeOrigin) && !is_string($routeOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeOrigin)), __LINE__);
        }
        if (is_null($routeOrigin) || (is_array($routeOrigin) && empty($routeOrigin))) {
            unset($this->RouteOrigin);
        } else {
            $this->RouteOrigin = $routeOrigin;
        }
        return $this;
    }
    /**
     * Get ServiceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }
    /**
     * Set ServiceType value
     * @uses \EnumType\ServiceTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\DtoTrackTransportWs
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->ServiceType = $serviceType;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\TrackTransportStatusEnum::valueIsValid()
     * @uses \EnumType\TrackTransportStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\DtoTrackTransportWs
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TrackTransportStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\TrackTransportStatusEnum::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TrackActivities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDtoTrackActivityWs|null
     */
    public function getTrackActivities()
    {
        return isset($this->TrackActivities) ? $this->TrackActivities : null;
    }
    /**
     * Set TrackActivities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDtoTrackActivityWs $trackActivities
     * @return \StructType\DtoTrackTransportWs
     */
    public function setTrackActivities(\ArrayType\ArrayOfDtoTrackActivityWs $trackActivities = null)
    {
        if (is_null($trackActivities) || (is_array($trackActivities) && empty($trackActivities))) {
            unset($this->TrackActivities);
        } else {
            $this->TrackActivities = $trackActivities;
        }
        return $this;
    }
    /**
     * Get TrackIncidences value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDtoTrackIncidenceWs|null
     */
    public function getTrackIncidences()
    {
        return isset($this->TrackIncidences) ? $this->TrackIncidences : null;
    }
    /**
     * Set TrackIncidences value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDtoTrackIncidenceWs $trackIncidences
     * @return \StructType\DtoTrackTransportWs
     */
    public function setTrackIncidences(\ArrayType\ArrayOfDtoTrackIncidenceWs $trackIncidences = null)
    {
        if (is_null($trackIncidences) || (is_array($trackIncidences) && empty($trackIncidences))) {
            unset($this->TrackIncidences);
        } else {
            $this->TrackIncidences = $trackIncidences;
        }
        return $this;
    }
    /**
     * Get TrackNotifications value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDtoTrackNotificationWs|null
     */
    public function getTrackNotifications()
    {
        return isset($this->TrackNotifications) ? $this->TrackNotifications : null;
    }
    /**
     * Set TrackNotifications value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDtoTrackNotificationWs $trackNotifications
     * @return \StructType\DtoTrackTransportWs
     */
    public function setTrackNotifications(\ArrayType\ArrayOfDtoTrackNotificationWs $trackNotifications = null)
    {
        if (is_null($trackNotifications) || (is_array($trackNotifications) && empty($trackNotifications))) {
            unset($this->TrackNotifications);
        } else {
            $this->TrackNotifications = $trackNotifications;
        }
        return $this;
    }
    /**
     * Get TrackTransportPointControls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDtoTrackTransportPointControlWs|null
     */
    public function getTrackTransportPointControls()
    {
        return isset($this->TrackTransportPointControls) ? $this->TrackTransportPointControls : null;
    }
    /**
     * Set TrackTransportPointControls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDtoTrackTransportPointControlWs $trackTransportPointControls
     * @return \StructType\DtoTrackTransportWs
     */
    public function setTrackTransportPointControls(\ArrayType\ArrayOfDtoTrackTransportPointControlWs $trackTransportPointControls = null)
    {
        if (is_null($trackTransportPointControls) || (is_array($trackTransportPointControls) && empty($trackTransportPointControls))) {
            unset($this->TrackTransportPointControls);
        } else {
            $this->TrackTransportPointControls = $trackTransportPointControls;
        }
        return $this;
    }
    /**
     * Get TrailerPlates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getTrailerPlates()
    {
        return isset($this->TrailerPlates) ? $this->TrailerPlates : null;
    }
    /**
     * Set TrailerPlates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $trailerPlates
     * @return \StructType\DtoTrackTransportWs
     */
    public function setTrailerPlates(\ArrayType\ArrayOfstring $trailerPlates = null)
    {
        if (is_null($trailerPlates) || (is_array($trailerPlates) && empty($trailerPlates))) {
            unset($this->TrailerPlates);
        } else {
            $this->TrailerPlates = $trailerPlates;
        }
        return $this;
    }
    /**
     * Get TrailerType value
     * @return string|null
     */
    public function getTrailerType()
    {
        return $this->TrailerType;
    }
    /**
     * Set TrailerType value
     * @uses \EnumType\TrailerTypeEnum::valueIsValid()
     * @uses \EnumType\TrailerTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trailerType
     * @return \StructType\DtoTrackTransportWs
     */
    public function setTrailerType($trailerType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TrailerTypeEnum::valueIsValid($trailerType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trailerType, implode(', ', \EnumType\TrailerTypeEnum::getValidValues())), __LINE__);
        }
        $this->TrailerType = $trailerType;
        return $this;
    }
    /**
     * Get Transit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransit()
    {
        return isset($this->Transit) ? $this->Transit : null;
    }
    /**
     * Set Transit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transit
     * @return \StructType\DtoTrackTransportWs
     */
    public function setTransit($transit = null)
    {
        // validation for constraint: string
        if (!is_null($transit) && !is_string($transit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transit)), __LINE__);
        }
        if (is_null($transit) || (is_array($transit) && empty($transit))) {
            unset($this->Transit);
        } else {
            $this->Transit = $transit;
        }
        return $this;
    }
    /**
     * Get TruckPlates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getTruckPlates()
    {
        return isset($this->TruckPlates) ? $this->TruckPlates : null;
    }
    /**
     * Set TruckPlates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $truckPlates
     * @return \StructType\DtoTrackTransportWs
     */
    public function setTruckPlates(\ArrayType\ArrayOfstring $truckPlates = null)
    {
        if (is_null($truckPlates) || (is_array($truckPlates) && empty($truckPlates))) {
            unset($this->TruckPlates);
        } else {
            $this->TruckPlates = $truckPlates;
        }
        return $this;
    }
    /**
     * Get Week value
     * @return int|null
     */
    public function getWeek()
    {
        return $this->Week;
    }
    /**
     * Set Week value
     * @param int $week
     * @return \StructType\DtoTrackTransportWs
     */
    public function setWeek($week = null)
    {
        // validation for constraint: int
        if (!is_null($week) && !is_numeric($week)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($week)), __LINE__);
        }
        $this->Week = $week;
        return $this;
    }
    /**
     * Get Year value
     * @return int|null
     */
    public function getYear()
    {
        return $this->Year;
    }
    /**
     * Set Year value
     * @param int $year
     * @return \StructType\DtoTrackTransportWs
     */
    public function setYear($year = null)
    {
        // validation for constraint: int
        if (!is_null($year) && !is_numeric($year)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($year)), __LINE__);
        }
        $this->Year = $year;
        return $this;
    }
    /**
     * Get highIncidences value
     * @return bool|null
     */
    public function getHighIncidences()
    {
        return $this->highIncidences;
    }
    /**
     * Set highIncidences value
     * @param bool $highIncidences
     * @return \StructType\DtoTrackTransportWs
     */
    public function setHighIncidences($highIncidences = null)
    {
        // validation for constraint: boolean
        if (!is_null($highIncidences) && !is_bool($highIncidences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($highIncidences)), __LINE__);
        }
        $this->highIncidences = $highIncidences;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoTrackTransportWs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
