<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DtoTrackTransportPointControlWs StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DtoTrackTransportPointControlWs
 * @subpackage Structs
 */
class DtoTrackTransportPointControlWs extends AbstractStructBase
{
    /**
     * The Datetime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Datetime;
    /**
     * The DatetimeOffSet
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatetimeOffSet;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The OffSet
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OffSet;
    /**
     * The RoutePointControlName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoutePointControlName;
    /**
     * The ScheduledDatetime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ScheduledDatetime;
    /**
     * The ScheduledDatetimeOffSet
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ScheduledDatetimeOffSet;
    /**
     * The TimeOffSet
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $TimeOffSet;
    /**
     * The TrackTransportId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TrackTransportId;
    /**
     * Constructor method for DtoTrackTransportPointControlWs
     * @uses DtoTrackTransportPointControlWs::setDatetime()
     * @uses DtoTrackTransportPointControlWs::setDatetimeOffSet()
     * @uses DtoTrackTransportPointControlWs::setId()
     * @uses DtoTrackTransportPointControlWs::setOffSet()
     * @uses DtoTrackTransportPointControlWs::setRoutePointControlName()
     * @uses DtoTrackTransportPointControlWs::setScheduledDatetime()
     * @uses DtoTrackTransportPointControlWs::setScheduledDatetimeOffSet()
     * @uses DtoTrackTransportPointControlWs::setTimeOffSet()
     * @uses DtoTrackTransportPointControlWs::setTrackTransportId()
     * @param string $datetime
     * @param string $datetimeOffSet
     * @param int $id
     * @param int $offSet
     * @param string $routePointControlName
     * @param string $scheduledDatetime
     * @param string $scheduledDatetimeOffSet
     * @param string $timeOffSet
     * @param int $trackTransportId
     */
    public function __construct($datetime = null, $datetimeOffSet = null, $id = null, $offSet = null, $routePointControlName = null, $scheduledDatetime = null, $scheduledDatetimeOffSet = null, $timeOffSet = null, $trackTransportId = null)
    {
        $this
            ->setDatetime($datetime)
            ->setDatetimeOffSet($datetimeOffSet)
            ->setId($id)
            ->setOffSet($offSet)
            ->setRoutePointControlName($routePointControlName)
            ->setScheduledDatetime($scheduledDatetime)
            ->setScheduledDatetimeOffSet($scheduledDatetimeOffSet)
            ->setTimeOffSet($timeOffSet)
            ->setTrackTransportId($trackTransportId);
    }
    /**
     * Get Datetime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatetime()
    {
        return isset($this->Datetime) ? $this->Datetime : null;
    }
    /**
     * Set Datetime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datetime
     * @return \StructType\DtoTrackTransportPointControlWs
     */
    public function setDatetime($datetime = null)
    {
        // validation for constraint: string
        if (!is_null($datetime) && !is_string($datetime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datetime)), __LINE__);
        }
        if (is_null($datetime) || (is_array($datetime) && empty($datetime))) {
            unset($this->Datetime);
        } else {
            $this->Datetime = $datetime;
        }
        return $this;
    }
    /**
     * Get DatetimeOffSet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatetimeOffSet()
    {
        return isset($this->DatetimeOffSet) ? $this->DatetimeOffSet : null;
    }
    /**
     * Set DatetimeOffSet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datetimeOffSet
     * @return \StructType\DtoTrackTransportPointControlWs
     */
    public function setDatetimeOffSet($datetimeOffSet = null)
    {
        // validation for constraint: string
        if (!is_null($datetimeOffSet) && !is_string($datetimeOffSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datetimeOffSet)), __LINE__);
        }
        if (is_null($datetimeOffSet) || (is_array($datetimeOffSet) && empty($datetimeOffSet))) {
            unset($this->DatetimeOffSet);
        } else {
            $this->DatetimeOffSet = $datetimeOffSet;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\DtoTrackTransportPointControlWs
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get OffSet value
     * @return int|null
     */
    public function getOffSet()
    {
        return $this->OffSet;
    }
    /**
     * Set OffSet value
     * @param int $offSet
     * @return \StructType\DtoTrackTransportPointControlWs
     */
    public function setOffSet($offSet = null)
    {
        // validation for constraint: int
        if (!is_null($offSet) && !is_numeric($offSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offSet)), __LINE__);
        }
        $this->OffSet = $offSet;
        return $this;
    }
    /**
     * Get RoutePointControlName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoutePointControlName()
    {
        return isset($this->RoutePointControlName) ? $this->RoutePointControlName : null;
    }
    /**
     * Set RoutePointControlName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routePointControlName
     * @return \StructType\DtoTrackTransportPointControlWs
     */
    public function setRoutePointControlName($routePointControlName = null)
    {
        // validation for constraint: string
        if (!is_null($routePointControlName) && !is_string($routePointControlName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routePointControlName)), __LINE__);
        }
        if (is_null($routePointControlName) || (is_array($routePointControlName) && empty($routePointControlName))) {
            unset($this->RoutePointControlName);
        } else {
            $this->RoutePointControlName = $routePointControlName;
        }
        return $this;
    }
    /**
     * Get ScheduledDatetime value
     * @return string|null
     */
    public function getScheduledDatetime()
    {
        return $this->ScheduledDatetime;
    }
    /**
     * Set ScheduledDatetime value
     * @param string $scheduledDatetime
     * @return \StructType\DtoTrackTransportPointControlWs
     */
    public function setScheduledDatetime($scheduledDatetime = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledDatetime) && !is_string($scheduledDatetime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduledDatetime)), __LINE__);
        }
        $this->ScheduledDatetime = $scheduledDatetime;
        return $this;
    }
    /**
     * Get ScheduledDatetimeOffSet value
     * @return string|null
     */
    public function getScheduledDatetimeOffSet()
    {
        return $this->ScheduledDatetimeOffSet;
    }
    /**
     * Set ScheduledDatetimeOffSet value
     * @param string $scheduledDatetimeOffSet
     * @return \StructType\DtoTrackTransportPointControlWs
     */
    public function setScheduledDatetimeOffSet($scheduledDatetimeOffSet = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledDatetimeOffSet) && !is_string($scheduledDatetimeOffSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduledDatetimeOffSet)), __LINE__);
        }
        $this->ScheduledDatetimeOffSet = $scheduledDatetimeOffSet;
        return $this;
    }
    /**
     * Get TimeOffSet value
     * @return string|null
     */
    public function getTimeOffSet()
    {
        return $this->TimeOffSet;
    }
    /**
     * Set TimeOffSet value
     * @param string $timeOffSet
     * @return \StructType\DtoTrackTransportPointControlWs
     */
    public function setTimeOffSet($timeOffSet = null)
    {
        // validation for constraint: maxInclusive
        if ($timeOffSet > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 0, "%s" given', $timeOffSet), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($timeOffSet < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $timeOffSet), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($timeOffSet) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $timeOffSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?", "%s" given', var_export($timeOffSet, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($timeOffSet) && !is_string($timeOffSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeOffSet)), __LINE__);
        }
        $this->TimeOffSet = $timeOffSet;
        return $this;
    }
    /**
     * Get TrackTransportId value
     * @return int|null
     */
    public function getTrackTransportId()
    {
        return $this->TrackTransportId;
    }
    /**
     * Set TrackTransportId value
     * @param int $trackTransportId
     * @return \StructType\DtoTrackTransportPointControlWs
     */
    public function setTrackTransportId($trackTransportId = null)
    {
        // validation for constraint: int
        if (!is_null($trackTransportId) && !is_numeric($trackTransportId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($trackTransportId)), __LINE__);
        }
        $this->TrackTransportId = $trackTransportId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoTrackTransportPointControlWs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
