<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DtoTrackActivityContentWs StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DtoTrackActivityContentWs
 * @subpackage Structs
 */
class DtoTrackActivityContentWs extends AbstractStructBase
{
    /**
     * The Chain
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Chain;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The IncidenceTypeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IncidenceTypeName;
    /**
     * The Packages
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Packages;
    /**
     * The TaccPackageIndicence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TaccPackageIndicence;
    /**
     * The TaccVolumeIncidence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TaccVolumeIncidence;
    /**
     * The TrackActivityId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TrackActivityId;
    /**
     * The TrackActivityWarehouseId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TrackActivityWarehouseId;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Volume
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Volume;
    /**
     * The WarehouseId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $WarehouseId;
    /**
     * The WarehouseName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WarehouseName;
    /**
     * Constructor method for DtoTrackActivityContentWs
     * @uses DtoTrackActivityContentWs::setChain()
     * @uses DtoTrackActivityContentWs::setId()
     * @uses DtoTrackActivityContentWs::setIncidenceTypeName()
     * @uses DtoTrackActivityContentWs::setPackages()
     * @uses DtoTrackActivityContentWs::setTaccPackageIndicence()
     * @uses DtoTrackActivityContentWs::setTaccVolumeIncidence()
     * @uses DtoTrackActivityContentWs::setTrackActivityId()
     * @uses DtoTrackActivityContentWs::setTrackActivityWarehouseId()
     * @uses DtoTrackActivityContentWs::setType()
     * @uses DtoTrackActivityContentWs::setVolume()
     * @uses DtoTrackActivityContentWs::setWarehouseId()
     * @uses DtoTrackActivityContentWs::setWarehouseName()
     * @param string $chain
     * @param int $id
     * @param string $incidenceTypeName
     * @param int $packages
     * @param int $taccPackageIndicence
     * @param int $taccVolumeIncidence
     * @param int $trackActivityId
     * @param int $trackActivityWarehouseId
     * @param string $type
     * @param float $volume
     * @param int $warehouseId
     * @param string $warehouseName
     */
    public function __construct($chain = null, $id = null, $incidenceTypeName = null, $packages = null, $taccPackageIndicence = null, $taccVolumeIncidence = null, $trackActivityId = null, $trackActivityWarehouseId = null, $type = null, $volume = null, $warehouseId = null, $warehouseName = null)
    {
        $this
            ->setChain($chain)
            ->setId($id)
            ->setIncidenceTypeName($incidenceTypeName)
            ->setPackages($packages)
            ->setTaccPackageIndicence($taccPackageIndicence)
            ->setTaccVolumeIncidence($taccVolumeIncidence)
            ->setTrackActivityId($trackActivityId)
            ->setTrackActivityWarehouseId($trackActivityWarehouseId)
            ->setType($type)
            ->setVolume($volume)
            ->setWarehouseId($warehouseId)
            ->setWarehouseName($warehouseName);
    }
    /**
     * Get Chain value
     * @return string|null
     */
    public function getChain()
    {
        return $this->Chain;
    }
    /**
     * Set Chain value
     * @uses \EnumType\ChainEnum::valueIsValid()
     * @uses \EnumType\ChainEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $chain
     * @return \StructType\DtoTrackActivityContentWs
     */
    public function setChain($chain = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ChainEnum::valueIsValid($chain)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $chain, implode(', ', \EnumType\ChainEnum::getValidValues())), __LINE__);
        }
        $this->Chain = $chain;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\DtoTrackActivityContentWs
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IncidenceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncidenceTypeName()
    {
        return isset($this->IncidenceTypeName) ? $this->IncidenceTypeName : null;
    }
    /**
     * Set IncidenceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $incidenceTypeName
     * @return \StructType\DtoTrackActivityContentWs
     */
    public function setIncidenceTypeName($incidenceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($incidenceTypeName) && !is_string($incidenceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($incidenceTypeName)), __LINE__);
        }
        if (is_null($incidenceTypeName) || (is_array($incidenceTypeName) && empty($incidenceTypeName))) {
            unset($this->IncidenceTypeName);
        } else {
            $this->IncidenceTypeName = $incidenceTypeName;
        }
        return $this;
    }
    /**
     * Get Packages value
     * @return int|null
     */
    public function getPackages()
    {
        return $this->Packages;
    }
    /**
     * Set Packages value
     * @param int $packages
     * @return \StructType\DtoTrackActivityContentWs
     */
    public function setPackages($packages = null)
    {
        // validation for constraint: int
        if (!is_null($packages) && !is_numeric($packages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packages)), __LINE__);
        }
        $this->Packages = $packages;
        return $this;
    }
    /**
     * Get TaccPackageIndicence value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTaccPackageIndicence()
    {
        return isset($this->TaccPackageIndicence) ? $this->TaccPackageIndicence : null;
    }
    /**
     * Set TaccPackageIndicence value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $taccPackageIndicence
     * @return \StructType\DtoTrackActivityContentWs
     */
    public function setTaccPackageIndicence($taccPackageIndicence = null)
    {
        // validation for constraint: int
        if (!is_null($taccPackageIndicence) && !is_numeric($taccPackageIndicence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($taccPackageIndicence)), __LINE__);
        }
        if (is_null($taccPackageIndicence) || (is_array($taccPackageIndicence) && empty($taccPackageIndicence))) {
            unset($this->TaccPackageIndicence);
        } else {
            $this->TaccPackageIndicence = $taccPackageIndicence;
        }
        return $this;
    }
    /**
     * Get TaccVolumeIncidence value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTaccVolumeIncidence()
    {
        return isset($this->TaccVolumeIncidence) ? $this->TaccVolumeIncidence : null;
    }
    /**
     * Set TaccVolumeIncidence value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $taccVolumeIncidence
     * @return \StructType\DtoTrackActivityContentWs
     */
    public function setTaccVolumeIncidence($taccVolumeIncidence = null)
    {
        // validation for constraint: int
        if (!is_null($taccVolumeIncidence) && !is_numeric($taccVolumeIncidence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($taccVolumeIncidence)), __LINE__);
        }
        if (is_null($taccVolumeIncidence) || (is_array($taccVolumeIncidence) && empty($taccVolumeIncidence))) {
            unset($this->TaccVolumeIncidence);
        } else {
            $this->TaccVolumeIncidence = $taccVolumeIncidence;
        }
        return $this;
    }
    /**
     * Get TrackActivityId value
     * @return int|null
     */
    public function getTrackActivityId()
    {
        return $this->TrackActivityId;
    }
    /**
     * Set TrackActivityId value
     * @param int $trackActivityId
     * @return \StructType\DtoTrackActivityContentWs
     */
    public function setTrackActivityId($trackActivityId = null)
    {
        // validation for constraint: int
        if (!is_null($trackActivityId) && !is_numeric($trackActivityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($trackActivityId)), __LINE__);
        }
        $this->TrackActivityId = $trackActivityId;
        return $this;
    }
    /**
     * Get TrackActivityWarehouseId value
     * @return int|null
     */
    public function getTrackActivityWarehouseId()
    {
        return $this->TrackActivityWarehouseId;
    }
    /**
     * Set TrackActivityWarehouseId value
     * @param int $trackActivityWarehouseId
     * @return \StructType\DtoTrackActivityContentWs
     */
    public function setTrackActivityWarehouseId($trackActivityWarehouseId = null)
    {
        // validation for constraint: int
        if (!is_null($trackActivityWarehouseId) && !is_numeric($trackActivityWarehouseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($trackActivityWarehouseId)), __LINE__);
        }
        $this->TrackActivityWarehouseId = $trackActivityWarehouseId;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\ActivityContentTypeEnum::valueIsValid()
     * @uses \EnumType\ActivityContentTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\DtoTrackActivityContentWs
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActivityContentTypeEnum::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\ActivityContentTypeEnum::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Volume value
     * @return float|null
     */
    public function getVolume()
    {
        return $this->Volume;
    }
    /**
     * Set Volume value
     * @param float $volume
     * @return \StructType\DtoTrackActivityContentWs
     */
    public function setVolume($volume = null)
    {
        $this->Volume = $volume;
        return $this;
    }
    /**
     * Get WarehouseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWarehouseId()
    {
        return isset($this->WarehouseId) ? $this->WarehouseId : null;
    }
    /**
     * Set WarehouseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $warehouseId
     * @return \StructType\DtoTrackActivityContentWs
     */
    public function setWarehouseId($warehouseId = null)
    {
        // validation for constraint: int
        if (!is_null($warehouseId) && !is_numeric($warehouseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($warehouseId)), __LINE__);
        }
        if (is_null($warehouseId) || (is_array($warehouseId) && empty($warehouseId))) {
            unset($this->WarehouseId);
        } else {
            $this->WarehouseId = $warehouseId;
        }
        return $this;
    }
    /**
     * Get WarehouseName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWarehouseName()
    {
        return isset($this->WarehouseName) ? $this->WarehouseName : null;
    }
    /**
     * Set WarehouseName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $warehouseName
     * @return \StructType\DtoTrackActivityContentWs
     */
    public function setWarehouseName($warehouseName = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseName) && !is_string($warehouseName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warehouseName)), __LINE__);
        }
        if (is_null($warehouseName) || (is_array($warehouseName) && empty($warehouseName))) {
            unset($this->WarehouseName);
        } else {
            $this->WarehouseName = $warehouseName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoTrackActivityContentWs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
