<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DtoRoutePointControlWs StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DtoRoutePointControlWs
 * @subpackage Structs
 */
class DtoRoutePointControlWs extends AbstractStructBase
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Longitude;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Radius
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Radius;
    /**
     * The TimeZoneCountryCountryName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimeZoneCountryCountryName;
    /**
     * Constructor method for DtoRoutePointControlWs
     * @uses DtoRoutePointControlWs::setActive()
     * @uses DtoRoutePointControlWs::setId()
     * @uses DtoRoutePointControlWs::setLatitude()
     * @uses DtoRoutePointControlWs::setLongitude()
     * @uses DtoRoutePointControlWs::setName()
     * @uses DtoRoutePointControlWs::setRadius()
     * @uses DtoRoutePointControlWs::setTimeZoneCountryCountryName()
     * @param bool $active
     * @param int $id
     * @param float $latitude
     * @param float $longitude
     * @param string $name
     * @param int $radius
     * @param string $timeZoneCountryCountryName
     */
    public function __construct($active = null, $id = null, $latitude = null, $longitude = null, $name = null, $radius = null, $timeZoneCountryCountryName = null)
    {
        $this
            ->setActive($active)
            ->setId($id)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setName($name)
            ->setRadius($radius)
            ->setTimeZoneCountryCountryName($timeZoneCountryCountryName);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\DtoRoutePointControlWs
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\DtoRoutePointControlWs
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\DtoRoutePointControlWs
     */
    public function setLatitude($latitude = null)
    {
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\DtoRoutePointControlWs
     */
    public function setLongitude($longitude = null)
    {
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\DtoRoutePointControlWs
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Radius value
     * @return int|null
     */
    public function getRadius()
    {
        return $this->Radius;
    }
    /**
     * Set Radius value
     * @param int $radius
     * @return \StructType\DtoRoutePointControlWs
     */
    public function setRadius($radius = null)
    {
        // validation for constraint: int
        if (!is_null($radius) && !is_numeric($radius)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($radius)), __LINE__);
        }
        $this->Radius = $radius;
        return $this;
    }
    /**
     * Get TimeZoneCountryCountryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeZoneCountryCountryName()
    {
        return isset($this->TimeZoneCountryCountryName) ? $this->TimeZoneCountryCountryName : null;
    }
    /**
     * Set TimeZoneCountryCountryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeZoneCountryCountryName
     * @return \StructType\DtoRoutePointControlWs
     */
    public function setTimeZoneCountryCountryName($timeZoneCountryCountryName = null)
    {
        // validation for constraint: string
        if (!is_null($timeZoneCountryCountryName) && !is_string($timeZoneCountryCountryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeZoneCountryCountryName)), __LINE__);
        }
        if (is_null($timeZoneCountryCountryName) || (is_array($timeZoneCountryCountryName) && empty($timeZoneCountryCountryName))) {
            unset($this->TimeZoneCountryCountryName);
        } else {
            $this->TimeZoneCountryCountryName = $timeZoneCountryCountryName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoRoutePointControlWs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
