<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DtoPlateCarrier StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DtoPlateCarrier
 * @subpackage Structs
 */
class DtoPlateCarrier extends DtoPlate
{
    /**
     * The CarrierId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CarrierId;
    /**
     * The CarrierName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CarrierName;
    /**
     * The Disabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Disabled;
    /**
     * Constructor method for DtoPlateCarrier
     * @uses DtoPlateCarrier::setCarrierId()
     * @uses DtoPlateCarrier::setCarrierName()
     * @uses DtoPlateCarrier::setDisabled()
     * @param int $carrierId
     * @param string $carrierName
     * @param bool $disabled
     */
    public function __construct($carrierId = null, $carrierName = null, $disabled = null)
    {
        $this
            ->setCarrierId($carrierId)
            ->setCarrierName($carrierName)
            ->setDisabled($disabled);
    }
    /**
     * Get CarrierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCarrierId()
    {
        return isset($this->CarrierId) ? $this->CarrierId : null;
    }
    /**
     * Set CarrierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $carrierId
     * @return \StructType\DtoPlateCarrier
     */
    public function setCarrierId($carrierId = null)
    {
        // validation for constraint: int
        if (!is_null($carrierId) && !is_numeric($carrierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($carrierId)), __LINE__);
        }
        if (is_null($carrierId) || (is_array($carrierId) && empty($carrierId))) {
            unset($this->CarrierId);
        } else {
            $this->CarrierId = $carrierId;
        }
        return $this;
    }
    /**
     * Get CarrierName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCarrierName()
    {
        return isset($this->CarrierName) ? $this->CarrierName : null;
    }
    /**
     * Set CarrierName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $carrierName
     * @return \StructType\DtoPlateCarrier
     */
    public function setCarrierName($carrierName = null)
    {
        // validation for constraint: string
        if (!is_null($carrierName) && !is_string($carrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierName)), __LINE__);
        }
        if (is_null($carrierName) || (is_array($carrierName) && empty($carrierName))) {
            unset($this->CarrierName);
        } else {
            $this->CarrierName = $carrierName;
        }
        return $this;
    }
    /**
     * Get Disabled value
     * @return bool|null
     */
    public function getDisabled()
    {
        return $this->Disabled;
    }
    /**
     * Set Disabled value
     * @param bool $disabled
     * @return \StructType\DtoPlateCarrier
     */
    public function setDisabled($disabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($disabled) && !is_bool($disabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($disabled)), __LINE__);
        }
        $this->Disabled = $disabled;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoPlateCarrier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
