<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DtoNewPlate StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DtoNewPlate
 * @subpackage Structs
 */
class DtoNewPlate extends AbstractStructBase
{
    /**
     * The ExternalId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ExternalId;
    /**
     * The PlateNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PlateNumber;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * Constructor method for DtoNewPlate
     * @uses DtoNewPlate::setExternalId()
     * @uses DtoNewPlate::setPlateNumber()
     * @uses DtoNewPlate::setType()
     * @param int $externalId
     * @param string $plateNumber
     * @param string $type
     */
    public function __construct($externalId = null, $plateNumber = null, $type = null)
    {
        $this
            ->setExternalId($externalId)
            ->setPlateNumber($plateNumber)
            ->setType($type);
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $externalId
     * @return \StructType\DtoNewPlate
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: int
        if (!is_null($externalId) && !is_numeric($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get PlateNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlateNumber()
    {
        return isset($this->PlateNumber) ? $this->PlateNumber : null;
    }
    /**
     * Set PlateNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plateNumber
     * @return \StructType\DtoNewPlate
     */
    public function setPlateNumber($plateNumber = null)
    {
        // validation for constraint: string
        if (!is_null($plateNumber) && !is_string($plateNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($plateNumber)), __LINE__);
        }
        if (is_null($plateNumber) || (is_array($plateNumber) && empty($plateNumber))) {
            unset($this->PlateNumber);
        } else {
            $this->PlateNumber = $plateNumber;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\PlateTypeEnum::valueIsValid()
     * @uses \EnumType\PlateTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\DtoNewPlate
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PlateTypeEnum::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\PlateTypeEnum::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoNewPlate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
