<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Active ServiceType
 * @subpackage Services
 */
class Active extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ActivePlate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivePlate $parameters
     * @return \StructType\ActivePlateResponse|bool
     */
    public function ActivePlate(\StructType\ActivePlate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ActivePlate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivePlateByExternalId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivePlateByExternalId $parameters
     * @return \StructType\ActivePlateByExternalIdResponse|bool
     */
    public function ActivePlateByExternalId(\StructType\ActivePlateByExternalId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ActivePlateByExternalId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ActivePlateByExternalIdResponse|\StructType\ActivePlateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
